/*\file PrintfFunction.c
 *\brief: this function is used by the _printf_ macro, to take into account the 
 *fact we may be running on a cluster. 
 */

#include "stdarg.h"
#include "stdio.h"

#ifdef _SERIAL_
#include "mex.h"
#endif

int PrintfFunction(char* format,...){

	/*string to be printed: */
	char string[1024]; //assume that nobody will print more than 1024 characters at once.
	int  string_size;
	extern int my_rank;
	extern int num_procs;
                                                                                                                                                                                                     
	//variable list of arguments
	va_list ap;

	//First use vsprintf to get the whole input string.
	va_start(ap,format);
	#ifndef WIN32
	string_size=vsprintf(string,format,ap); //printf style coding 
	#else
	string_size=vsprintf_s(string,format,ap); //printf style coding 
	#endif
	va_end(ap); 

	//Ok, if we are running in paralle, get node 0 to print
	#if defined(_PARALLEL_)
		if(my_rank==0)printf(string);
	#else
		mexPrintf(string);
	#endif

	return 1;
}
