/*!\file OptionsUtilities.cpp
 * \brief: implementation of the options utilities
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*FUNCTION ColumnWiseDimsFromIndex{{{1*/
int ColumnWiseDimsFromIndex(int* dims,int index,int* size,int ndims){

	int   i;
	int   aprod=1;

	/*check for index too large  */
	for (i=0;i<ndims;i++) aprod*=size[i];
	if (index >= aprod) _error_("Index %d exceeds number of elements %d.",index,aprod);

	/*calculate the dimensions (being careful of integer division)  */
	for (i=ndims-1; i>=0; i--) {
		aprod=(int)(((double)aprod+0.5)/(double)size[i]);
		dims[i]=(int)floor(((double)index+0.5)/(double)aprod);
		index-=dims[i]*aprod;
	}

	return(0);
}/*}}}*/
/*FUNCTION IndexFromColumnWiseDims{{{1*/
int IndexFromColumnWiseDims(int* dims, int* size, int ndims) {

	int   i;
	int   index=0;

	/*check for any dimension too large  */
	for (i=0;i<ndims;i++){
		if (dims[i] >= size[i]) _error_("Dimension %d of %d exceeds size of %d.",i,dims[i],size[i]);
	}

	/*calculate the index  */
	for (i=ndims-1; i>=0; i--){
		index*=size[i];
		index+=dims[i];
	}

	return(index);
}/*}}}*/
/*FUNCTION RowWiseDimsFromIndex{{{1*/
int RowWiseDimsFromIndex(int* dims, int index, int* size, int ndims) {

	int   i;
	int   aprod=1;

	/*check for index too large  */
	for (i=0; i<ndims; i++) aprod*=size[i];
	if (index >= aprod) _error_("Index %d exceeds number of elements %d.",index,aprod);

	/*calculate the dimensions (being careful of integer division)  */
	for (i=0; i<ndims; i++) {
		aprod=(int)(((double)aprod+0.5)/(double)size[i]);
		dims[i]=(int)floor(((double)index+0.5)/(double)aprod);
		index-=dims[i]*aprod;
	}

	return(0);
}/*}}}*/
/*FUNCTION IndexFromRowWiseDims{{{1*/
int IndexFromRowWiseDims(int* dims, int* size, int ndims) {

	int   i;
	int   index=0;

	/*check for any dimension too large  */
	for (i=0; i<ndims; i++){
		if (dims[i] >= size[i]) _error_("Dimension %d of %d exceeds size of %d.",i,dims[i],size[i]);
	}

	/*calculate the index  */
	for (i=0; i<ndims; i++) {
		index*=size[i];
		index+=dims[i];
	}

	return(index);
}/*}}}*/
/*FUNCTION StringFromDims{{{1*/
int StringFromDims(char* cstr, int* dims, int ndims) {

	sprintf(&cstr[0],"[");
	for(int i=0; i<ndims-1; i++) sprintf(&cstr[strlen(cstr)],"%d,",dims[i]);
	sprintf(&cstr[strlen(cstr)],"%d]",dims[ndims-1]);

	return(0);
}/*}}}*/
/*FUNCTION StringFromSize{{{1*/
int StringFromSize(char* cstr, int* size, int ndims) {

	sprintf(&cstr[0],"[");
	for(int i=0; i<ndims-1; i++) sprintf(&cstr[strlen(cstr)],"%dx",size[i]);
	sprintf(&cstr[strlen(cstr)],"%d]",size[ndims-1]);

	return(0);
}/*}}}*/
