/*!\file OptionsChar.cpp
 * \brief: implementation of the optionschar object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionsChar::OptionsChar(){{{1*/
OptionsChar::OptionsChar(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionsChar::~OptionsChar(){{{1*/
OptionsChar::~OptionsChar(){

	if (values) xfree((void**)&values);

}
/*}}}*/

/*Other*/
/*FUNCTION OptionsChar::Echo {{{1*/
void  OptionsChar::Echo(){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"OptionsChar Echo:\n");
	Option::Echo();

	if (values && size) {
//		if (numel == 1) {
		if (1) {
//			_printf_(flag,"        values: \"%s\"\n" ,values[0]);
			_printf_(flag,"        values: \"%s\"\n" ,values);
		}
		else {
			StringFromSize(cstr,size,ndims);
			_printf_(flag,"        values: %s %s\n" ,cstr,"char");
		}
	}
	else _printf_(flag,"        values: [empty]\n" );
}
/*}}}*/
/*FUNCTION OptionsChar::DeepEcho() {{{1*/
void  OptionsChar::DeepEcho(){

	char  indent[81]="";

	OptionsChar::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION OptionsChar::DeepEcho(char* indent) {{{1*/
void  OptionsChar::DeepEcho(char* indent){

	int   i;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%sOptionsChar DeepEcho:\n",indent);
	Option::DeepEcho(indent);

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	if (values) {
//		if (numel == 1) {
		if (1) {
//			_printf_(flag,"%s        values: \"%s\"\n" ,indent,values[0]);
			_printf_(flag,"%s        values: \"%s\"\n" ,indent,values);
		}
		else {
			dims=(int *) xmalloc(ndims*sizeof(int));
			for (i=0; i<numel; i++) {
				RowWiseDimsFromIndex(dims,i,size,ndims);
				StringFromDims(cstr,dims,ndims);
				_printf_(flag,"%s        values%s: \"%s\"\n" ,indent,cstr,values[i]);
			}
			xfree((void**)&dims);
		}
	}
	else _printf_(flag,"%s        values: [empty]\n" ,indent);
}
/*}}}*/
/*FUNCTION OptionsChar::Name {{{1*/
char* OptionsChar::Name(){

	return(Option::Name());
}
/*}}}*/
/*FUNCTION OptionsChar::NumEl {{{1*/
int   OptionsChar::NumEl(){

	return(Option::NumEl());
}
/*}}}*/
/*FUNCTION OptionsChar::NDims {{{1*/
int   OptionsChar::NDims(){

	return(Option::NDims());
}
/*}}}*/
/*FUNCTION OptionsChar::Size {{{1*/
int*  OptionsChar::Size(){

	return(Option::Size());
}
/*}}}*/
/*FUNCTION OptionsChar::Get {{{1*/
//void* OptionsChar::Get(){

//	;

//	return;
//}
/*}}}*/
