/*! \file Option.h 
 *  \brief: header file for optionsobject abstract object
 */

#ifndef _OPTIONSOBJECT_H_
#define _OPTIONSOBJECT_H_

/*Headers:{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "../Object.h"
/*}}}*/

class Option: public Object {

	public:

		char* name;
		int   numel;
		int   ndims;
		int*  size;

		/*Option constructors, destructors {{{1*/
		Option();
		~Option();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		int   Id(){_error_("Not implemented yet");};
		int   MyRank(){_error_("Not implemented yet");};
		void  Marshall(char** pmarshalled_dataset){_error_("Not implemented yet");};
		int   MarshallSize(){_error_("Not implemented yet");};
		void  Demarshall(char** pmarshalled_dataset){_error_("Not implemented yet");};
		int   Enum(){_error_("Not implemented yet");};
		Object* copy(){_error_("Not implemented yet");};
		/*}}}*/

		/*virtual functions: */
		virtual char* Name()=0;
		virtual int   NumEl()=0;
		virtual int   NDims()=0;
		virtual int*  Size()=0;
//		virtual Object* Get()=0;
//  get by single index, multiple index, simple find, recursive find

};
#endif  /* _OPTIONSOBJECT_H */

