/*! \file OptionsUtilities.h 
 *  \brief: header file for options utilities
 */

#ifndef _OPTIONSUTILITIES_H_
#define _OPTIONSUTILITIES_H_

/*Headers:{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./OptionsObject.h"
/*}}}*/

int ColumnWiseDimsFromIndex(int* dims,
							int index,
							int* size,
							int ndims);
int IndexFromColumnWiseDims(int* dims,
							int* size,
							int ndims);
int RowWiseDimsFromIndex(int* dims,
						 int index,
						 int* size,
						 int ndims);
int IndexFromRowWiseDims(int* dims,
						 int* size,
						 int ndims);
int StringFromDims(char* cstr,
				   int* dims,
				   int ndims);
int StringFromSize(char* cstr,
				   int* size,
				   int ndims);

#endif  /* _OPTIONSUTILITIES_H */

