/*!\file OptionsStruct.cpp
 * \brief: implementation of the optionsstruct object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionsStruct::OptionsStruct(){{{1*/
OptionsStruct::OptionsStruct(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionsStruct::~OptionsStruct(){{{1*/
OptionsStruct::~OptionsStruct(){

	int   i;

	if (values) {
		for (i=0; i<numel; i++) {
			delete values[i];
			values[i] =NULL;
		}
		xfree((void**)&values);
	}

}
/*}}}*/

/*Other*/
/*FUNCTION OptionsStruct::Echo {{{1*/
void  OptionsStruct::Echo(){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"OptionsStruct Echo:\n");
	OptionsObject::Echo();

	if (values && size) {
		StringFromSize(cstr,
					   size,
					   ndims);
		_printf_(flag,"        values: %s %s\n" ,cstr,"struct");
	}
	else
		_printf_(flag,"        values: [empty]\n" );

	return;
}
/*}}}*/

/*FUNCTION OptionsStruct::DeepEcho {{{1*/
void  OptionsStruct::DeepEcho(){

	char  indent[81]="";

	OptionsStruct::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION OptionsStruct::DeepEcho {{{1*/
void  OptionsStruct::DeepEcho(char* indent){

	int   i,j;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%sOptionsStruct DeepEcho:\n",indent);
	OptionsObject::DeepEcho(indent);

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	if (values) {
		dims=(int *) xmalloc(ndims*sizeof(int));
		for (i=0; i<numel; i++) {
			ColumnWiseDimsFromIndex(dims,
									i,
									size,
									ndims);
			StringFromDims(cstr,
						   dims,
						   ndims);
			if (values[i]->Size()) {
				_printf_(flag,"%s        values: %s begin\n" ,indent,cstr);
				for (j=0; j<values[i]->Size(); j++)
					((OptionsObject *)values[i]->GetObjectByOffset(j))->DeepEcho(indent2);
				_printf_(flag,"%s        values: %s end\n"   ,indent,cstr);
			}
			else
				_printf_(flag,"%s        values: %s [empty]\n" ,indent,cstr);
		}
		xfree((void**)&dims);
	}
	else
		_printf_(flag,"%s        values: [empty]\n" ,indent);

	return;
}
/*}}}*/

/*FUNCTION OptionsStruct::Name {{{1*/
char* OptionsStruct::Name(){

	return(OptionsObject::Name());
}
/*}}}*/

/*FUNCTION OptionsStruct::NumEl {{{1*/
int   OptionsStruct::NumEl(){

	return(OptionsObject::NumEl());
}
/*}}}*/

/*FUNCTION OptionsStruct::NDims {{{1*/
int   OptionsStruct::NDims(){

	return(OptionsObject::NDims());
}
/*}}}*/

/*FUNCTION OptionsStruct::Size {{{1*/
int*  OptionsStruct::Size(){

	return(OptionsObject::Size());
}
/*}}}*/

/*FUNCTION OptionsStruct::Get {{{1*/
//void* OptionsStruct::Get(){

//	;

//	return;
//}
/*}}}*/

/*FUNCTION OptionsStruct::Id {{{1*/
int   OptionsStruct::Id(){
}
/*}}}*/

/*FUNCTION OptionsStruct::MyRank {{{1*/
int   OptionsStruct::MyRank(){
}
/*}}}*/

/*FUNCTION OptionsStruct::Marshall {{{1*/
void  OptionsStruct::Marshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION OptionsStruct::MarshallSize {{{1*/
int   OptionsStruct::MarshallSize(){
}
/*}}}*/

/*FUNCTION OptionsStruct::Demarshall {{{1*/
void  OptionsStruct::Demarshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION OptionsStruct::Enum {{{1*/
int   OptionsStruct::Enum(){
}
/*}}}*/

/*FUNCTION OptionsStruct::copy {{{1*/
Object* OptionsStruct::copy(){
}
/*}}}*/

