/*! \file OptionsDouble.h 
 *  \brief: header file for optionsdouble object
 */

#ifndef _OPTIONSDOUBLE_H_
#define _OPTIONSDOUBLE_H_

/*Headers:{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./OptionsObject.h"
/*}}}*/

class OptionsDouble: public OptionsObject {

	public:

		double* values;

		/*OptionsDouble constructors, destructors {{{1*/
		OptionsDouble();
		~OptionsDouble();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		int   Id();
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/

		/*virtual functions: */
		char* Name();
		int   NumEl();
		int   NDims();
		int*  Size();
//		Object* Get();
//  get by single index, multiple index, simple find, recursive find

};
#endif  /* _OPTIONSDOUBLE_H */

