/*!\file OptionsDouble.cpp
 * \brief: implementation of the optionsdouble object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionsDouble::OptionsDouble(){{{1*/
OptionsDouble::OptionsDouble(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionsDouble::~OptionsDouble(){{{1*/
OptionsDouble::~OptionsDouble(){

	if (values) xfree((void**)&values);

}
/*}}}*/

/*Other*/
/*FUNCTION OptionsDouble::Echo {{{1*/
void  OptionsDouble::Echo(){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"OptionsDouble Echo:\n");
	OptionsObject::Echo();

	if (values && size) {
		if (numel == 1) {
			_printf_(flag,"        values: %g\n" ,values[0]);
		}
		else {
			StringFromSize(cstr,
						   size,
						   ndims);
			_printf_(flag,"        values: %s %s\n" ,cstr,"double");
		}
	}
	else
		_printf_(flag,"        values: [empty]\n" );

	return;
}
/*}}}*/

/*FUNCTION OptionsDouble::DeepEcho {{{1*/
void  OptionsDouble::DeepEcho(){

	char  indent[81]="";

	OptionsDouble::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION OptionsDouble::DeepEcho {{{1*/
void  OptionsDouble::DeepEcho(char* indent){

	int   i;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%sOptionsDouble DeepEcho:\n",indent);
	OptionsObject::DeepEcho(indent);

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	if (values) {
		dims=(int *) xmalloc(ndims*sizeof(int));
		if (numel == 1) {
			_printf_(flag,"%s        values: %g\n" ,indent,values[0]);
		}
		else {
			for (i=0; i<numel; i++) {
				RowWiseDimsFromIndex(dims,
									 i,
									 size,
									 ndims);
				StringFromDims(cstr,
							   dims,
							   ndims);
				_printf_(flag,"%s        values%s: %g\n" ,indent,cstr,values[i]);
			}
		}
		xfree((void**)&dims);
	}
	else
		_printf_(flag,"%s        values: [empty]\n" ,indent);

	return;
}
/*}}}*/

/*FUNCTION OptionsDouble::Name {{{1*/
char* OptionsDouble::Name(){

	return(OptionsObject::Name());
}
/*}}}*/

/*FUNCTION OptionsDouble::NumEl {{{1*/
int   OptionsDouble::NumEl(){

	return(OptionsObject::NumEl());
}
/*}}}*/

/*FUNCTION OptionsDouble::NDims {{{1*/
int   OptionsDouble::NDims(){

	return(OptionsObject::NDims());
}
/*}}}*/

/*FUNCTION OptionsDouble::Size {{{1*/
int*  OptionsDouble::Size(){

	return(OptionsObject::Size());
}
/*}}}*/

/*FUNCTION OptionsDouble::Get {{{1*/
//void* OptionsDouble::Get(){

//	;

//	return;
//}
/*}}}*/

/*FUNCTION OptionsDouble::Id {{{1*/
int   OptionsDouble::Id(){
}
/*}}}*/

/*FUNCTION OptionsDouble::MyRank {{{1*/
int   OptionsDouble::MyRank(){
}
/*}}}*/

/*FUNCTION OptionsDouble::Marshall {{{1*/
void  OptionsDouble::Marshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION OptionsDouble::MarshallSize {{{1*/
int   OptionsDouble::MarshallSize(){
}
/*}}}*/

/*FUNCTION OptionsDouble::Demarshall {{{1*/
void  OptionsDouble::Demarshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION OptionsDouble::Enum {{{1*/
int   OptionsDouble::Enum(){
}
/*}}}*/

/*FUNCTION OptionsDouble::copy {{{1*/
Object* OptionsDouble::copy(){
}
/*}}}*/

