/*!\file OptionsChar.cpp
 * \brief: implementation of the optionschar object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionsChar::OptionsChar(){{{1*/
OptionsChar::OptionsChar(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionsChar::~OptionsChar(){{{1*/
OptionsChar::~OptionsChar(){

	if (values) xfree((void**)&values);

}
/*}}}*/

/*Other*/
/*FUNCTION OptionsChar::Echo {{{1*/
void  OptionsChar::Echo(){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"OptionsChar Echo:\n");
	OptionsObject::Echo();

	if (values && size) {
//		if (numel == 1) {
		if (1) {
//			_printf_(flag,"        values: \"%s\"\n" ,values[0]);
			_printf_(flag,"        values: \"%s\"\n" ,values);
		}
		else {
			StringFromSize(cstr,
						   size,
						   ndims);
			_printf_(flag,"        values: %s %s\n" ,cstr,"char");
		}
	}
	else
		_printf_(flag,"        values: [empty]\n" );

	return;
}
/*}}}*/

/*FUNCTION OptionsChar::DeepEcho {{{1*/
void  OptionsChar::DeepEcho(){

	char  indent[81]="";

	OptionsChar::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION OptionsChar::DeepEcho {{{1*/
void  OptionsChar::DeepEcho(char* indent){

	int   i;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%sOptionsChar DeepEcho:\n",indent);
	OptionsObject::DeepEcho(indent);

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	if (values) {
//		if (numel == 1) {
		if (1) {
//			_printf_(flag,"%s        values: \"%s\"\n" ,indent,values[0]);
			_printf_(flag,"%s        values: \"%s\"\n" ,indent,values);
		}
		else {
			dims=(int *) xmalloc(ndims*sizeof(int));
			for (i=0; i<numel; i++) {
				RowWiseDimsFromIndex(dims,
									 i,
									 size,
									 ndims);
				StringFromDims(cstr,
							   dims,
							   ndims);
				_printf_(flag,"%s        values%s: \"%s\"\n" ,indent,cstr,values[i]);
			}
			xfree((void**)&dims);
		}
	}
	else
		_printf_(flag,"%s        values: [empty]\n" ,indent);

	return;
}
/*}}}*/

/*FUNCTION OptionsChar::Name {{{1*/
char* OptionsChar::Name(){

	return(OptionsObject::Name());
}
/*}}}*/

/*FUNCTION OptionsChar::NumEl {{{1*/
int   OptionsChar::NumEl(){

	return(OptionsObject::NumEl());
}
/*}}}*/

/*FUNCTION OptionsChar::NDims {{{1*/
int   OptionsChar::NDims(){

	return(OptionsObject::NDims());
}
/*}}}*/

/*FUNCTION OptionsChar::Size {{{1*/
int*  OptionsChar::Size(){

	return(OptionsObject::Size());
}
/*}}}*/

/*FUNCTION OptionsChar::Get {{{1*/
//void* OptionsChar::Get(){

//	;

//	return;
//}
/*}}}*/

/*FUNCTION OptionsChar::Id {{{1*/
int   OptionsChar::Id(){
}
/*}}}*/

/*FUNCTION OptionsChar::MyRank {{{1*/
int   OptionsChar::MyRank(){
}
/*}}}*/

/*FUNCTION OptionsChar::Marshall {{{1*/
void  OptionsChar::Marshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION OptionsChar::MarshallSize {{{1*/
int   OptionsChar::MarshallSize(){
}
/*}}}*/

/*FUNCTION OptionsChar::Demarshall {{{1*/
void  OptionsChar::Demarshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION OptionsChar::Enum {{{1*/
int   OptionsChar::Enum(){
}
/*}}}*/

/*FUNCTION OptionsChar::copy {{{1*/
Object* OptionsChar::copy(){
}
/*}}}*/

