/*!\file OptionsObject.cpp
 * \brief: implementation of the optionsobject abstract object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionsObject::OptionsObject(){{{1*/
OptionsObject::OptionsObject(){

	name      =NULL;
	numel     =0;
	ndims     =0;
	size      =NULL;

}
/*}}}*/
/*FUNCTION OptionsObject::~OptionsObject(){{{1*/
OptionsObject::~OptionsObject(){

	if (size) xfree((void**)&size);
	if (name) xfree((void**)&name);

}
/*}}}*/

/*Other*/
/*FUNCTION OptionsObject::Echo {{{1*/
void  OptionsObject::Echo(){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"          name: \"%s\"\n" ,name);
	_printf_(flag,"         numel: %d\n"     ,numel);
	_printf_(flag,"         ndims: %d\n"     ,ndims);
	if (size) {
		StringFromSize(cstr,
					   size,
					   ndims);
		_printf_(flag,"          size: %s\n" ,cstr);
	}
	else
		_printf_(flag,"          size: [empty]\n" );

	return;
}
/*}}}*/

/*FUNCTION OptionsObject::DeepEcho {{{1*/
void  OptionsObject::DeepEcho(){

	char  indent[81]="";

	OptionsObject::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION OptionsObject::DeepEcho {{{1*/
void  OptionsObject::DeepEcho(char* indent){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%s          name: \"%s\"\n" ,indent,name);
	_printf_(flag,"%s         numel: %d\n"     ,indent,numel);
	_printf_(flag,"%s         ndims: %d\n"     ,indent,ndims);
	if (size) {
		StringFromSize(cstr,
					   size,
					   ndims);
		_printf_(flag,"%s          size: %s\n" ,indent,cstr);
	}
	else
		_printf_(flag,"%s          size: [empty]\n" ,indent);

	return;
}
/*}}}*/

/*FUNCTION OptionsObject::Name {{{1*/
char* OptionsObject::Name(){

	return(name);
}
/*}}}*/

/*FUNCTION OptionsObject::NumEl {{{1*/
int   OptionsObject::NumEl(){

	return(numel);
}
/*}}}*/

/*FUNCTION OptionsObject::NDims {{{1*/
int   OptionsObject::NDims(){

	return(ndims);
}
/*}}}*/

/*FUNCTION OptionsObject::Size {{{1*/
int*  OptionsObject::Size(){

	return(size);
}
/*}}}*/

/*FUNCTION OptionsObject::Get {{{1*/
//void* OptionsObject::Get(){

//	;

//	return;
//}
/*}}}*/

/*FUNCTION OptionsObject::Id {{{1*/
int   OptionsObject::Id(){
}
/*}}}*/

/*FUNCTION OptionsObject::MyRank {{{1*/
int   OptionsObject::MyRank(){
}
/*}}}*/

/*FUNCTION OptionsObject::Marshall {{{1*/
void  OptionsObject::Marshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION OptionsObject::MarshallSize {{{1*/
int   OptionsObject::MarshallSize(){
}
/*}}}*/

/*FUNCTION OptionsObject::Demarshall {{{1*/
void  OptionsObject::Demarshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION OptionsObject::Enum {{{1*/
int   OptionsObject::Enum(){
}
/*}}}*/

/*FUNCTION OptionsObject::copy {{{1*/
Object* OptionsObject::copy(){
}
/*}}}*/

