/*!\file OptionsLogical.cpp
 * \brief: implementation of the optionslogical object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionsLogical::OptionsLogical(){{{1*/
OptionsLogical::OptionsLogical(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionsLogical::~OptionsLogical(){{{1*/
OptionsLogical::~OptionsLogical(){

	if (values) xfree((void**)&values);

}
/*}}}*/

/*Other*/
/*FUNCTION OptionsLogical::Echo {{{1*/
void  OptionsLogical::Echo(){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"OptionsLogical Echo:\n");
	OptionsObject::Echo();

	if (values && size) {
		if (numel == 1) {
			_printf_(flag,"        values: %s\n" ,(values[0] ? "true" : "false"));
		}
		else {
			StringFromSize(cstr,
						   size,
						   ndims);
			_printf_(flag,"        values: %s %s\n" ,cstr,"logical");
		}
	}
	else
		_printf_(flag,"        values: [empty]\n" );

	return;
}
/*}}}*/

/*FUNCTION OptionsLogical::DeepEcho {{{1*/
void  OptionsLogical::DeepEcho(){

	char  indent[81]="";

	OptionsLogical::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION OptionsLogical::DeepEcho {{{1*/
void  OptionsLogical::DeepEcho(char* indent){

	int   i;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%sOptionsLogical DeepEcho:\n",indent);
	OptionsObject::DeepEcho(indent);

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	if (values) {
		if (numel == 1) {
			_printf_(flag,"%s        values: %s\n" ,indent,(values[0] ? "true" : "false"));
		}
		else {
			dims=(int *) xmalloc(ndims*sizeof(int));
			for (i=0; i<numel; i++) {
				RowWiseDimsFromIndex(dims,
									 i,
									 size,
									 ndims);
				StringFromDims(cstr,
							   dims,
							   ndims);
				_printf_(flag,"%s        values%s: %s\n" ,indent,cstr,(values[i] ? "true" : "false"));
			}
			xfree((void**)&dims);
		}
	}
	else
		_printf_(flag,"%s        values: [empty]\n" ,indent);

	return;
}
/*}}}*/

/*FUNCTION OptionsLogical::Name {{{1*/
char* OptionsLogical::Name(){

	return(OptionsObject::Name());
}
/*}}}*/

/*FUNCTION OptionsLogical::NumEl {{{1*/
int   OptionsLogical::NumEl(){

	return(OptionsObject::NumEl());
}
/*}}}*/

/*FUNCTION OptionsLogical::NDims {{{1*/
int   OptionsLogical::NDims(){

	return(OptionsObject::NDims());
}
/*}}}*/

/*FUNCTION OptionsLogical::Size {{{1*/
int*  OptionsLogical::Size(){

	return(OptionsObject::Size());
}
/*}}}*/

/*FUNCTION OptionsLogical::Get {{{1*/
//void* OptionsLogical::Get(){

//	;

//	return;
//}
/*}}}*/

/*FUNCTION OptionsLogical::Id {{{1*/
int   OptionsLogical::Id(){
}
/*}}}*/

/*FUNCTION OptionsLogical::MyRank {{{1*/
int   OptionsLogical::MyRank(){
}
/*}}}*/

/*FUNCTION OptionsLogical::Marshall {{{1*/
void  OptionsLogical::Marshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION OptionsLogical::MarshallSize {{{1*/
int   OptionsLogical::MarshallSize(){
}
/*}}}*/

/*FUNCTION OptionsLogical::Demarshall {{{1*/
void  OptionsLogical::Demarshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION OptionsLogical::Enum {{{1*/
int   OptionsLogical::Enum(){
}
/*}}}*/

/*FUNCTION OptionsLogical::copy {{{1*/
Object* OptionsLogical::copy(){
}
/*}}}*/

