/*!\file OptionsCell.cpp
 * \brief: implementation of the optionscell object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionsCell::OptionsCell(){{{1*/
OptionsCell::OptionsCell(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionsCell::~OptionsCell(){{{1*/
OptionsCell::~OptionsCell(){

	if (values) {
		delete values;
		values    =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION OptionsCell::Echo {{{1*/
void  OptionsCell::Echo(){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"OptionsCell Echo:\n");
	OptionsObject::Echo();

	if (values && size) {
		StringFromSize(cstr,
					   size,
					   ndims);
		_printf_(flag,"        values: %s %s\n" ,cstr,"cell");
	}
	else
		_printf_(flag,"        values: [empty]\n" );

	return;
}
/*}}}*/

/*FUNCTION OptionsCell::DeepEcho {{{1*/
void  OptionsCell::DeepEcho(){

	char  indent[81]="";

	OptionsCell::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION OptionsCell::DeepEcho {{{1*/
void  OptionsCell::DeepEcho(char* indent){

	int   i;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%sOptionsCell DeepEcho:\n",indent);
	OptionsObject::DeepEcho(indent);

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	if (values->Size()) {
		dims=(int *) xmalloc(ndims*sizeof(int));
		for (i=0; i<values->Size(); i++) {
			ColumnWiseDimsFromIndex(dims,
									i,
									size,
									ndims);
			StringFromDims(cstr,
						   dims,
						   ndims);
			_printf_(flag,"%s        values: %s begin\n" ,indent,cstr);
			((OptionsObject *)values->GetObjectByOffset(i))->DeepEcho(indent2);
			_printf_(flag,"%s        values: %s end\n"   ,indent,cstr);
		}
		xfree((void**)&dims);
	}
	else
		_printf_(flag,"%s        values: [empty]\n" ,indent);

	return;
}
/*}}}*/

/*FUNCTION OptionsCell::Name {{{1*/
char* OptionsCell::Name(){

	return(OptionsObject::Name());
}
/*}}}*/

/*FUNCTION OptionsCell::NumEl {{{1*/
int   OptionsCell::NumEl(){

	return(OptionsObject::NumEl());
}
/*}}}*/

/*FUNCTION OptionsCell::NDims {{{1*/
int   OptionsCell::NDims(){

	return(OptionsObject::NDims());
}
/*}}}*/

/*FUNCTION OptionsCell::Size {{{1*/
int*  OptionsCell::Size(){

	return(OptionsObject::Size());
}
/*}}}*/

/*FUNCTION OptionsCell::Get {{{1*/
//void* OptionsCell::Get(){

//	;

//	return;
//}
/*}}}*/

/*FUNCTION OptionsCell::Id {{{1*/
int   OptionsCell::Id(){
}
/*}}}*/

/*FUNCTION OptionsCell::MyRank {{{1*/
int   OptionsCell::MyRank(){
}
/*}}}*/

/*FUNCTION OptionsCell::Marshall {{{1*/
void  OptionsCell::Marshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION OptionsCell::MarshallSize {{{1*/
int   OptionsCell::MarshallSize(){
}
/*}}}*/

/*FUNCTION OptionsCell::Demarshall {{{1*/
void  OptionsCell::Demarshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION OptionsCell::Enum {{{1*/
int   OptionsCell::Enum(){
}
/*}}}*/

/*FUNCTION OptionsCell::copy {{{1*/
Object* OptionsCell::copy(){
}
/*}}}*/

