/*!\file: CreateParametersDiagnosticHoriz.cpp
 * \brief driver for creating parameters dataset, for diagnostic horiz analysis.
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateParametersDiagnosticHoriz"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../Model.h"

void CreateParametersDiagnosticHoriz(DataSet** pparameters,Model* model,ConstDataHandle model_handle){
	
	Param*   param = NULL;
	DataSet* parameters=NULL;
	int      count;
	int i;

	double* vx=NULL;
	double* vy=NULL;
	double* vz=NULL;
	double* ug=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	count=parameters->Size();

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (!model->ismacayealpattyn)return;

	/*Get vx and vy: */
	ModelFetchData((void**)&vx,NULL,NULL,model_handle,"vx","Matrix","Mat");
	ModelFetchData((void**)&vy,NULL,NULL,model_handle,"vy","Matrix","Mat");
	ModelFetchData((void**)&vz,NULL,NULL,model_handle,"vz","Matrix","Mat");

	ug=(double*)xcalloc(model->numberofnodes*3,sizeof(double));

	if(vx) for(i=0;i<model->numberofnodes;i++)ug[3*i+0]=vx[i]/model->yts;
	if(vy) for(i=0;i<model->numberofnodes;i++)ug[3*i+1]=vy[i]/model->yts;
	if(vz) for(i=0;i<model->numberofnodes;i++)ug[3*i+2]=vz[i]/model->yts;

	count++;
	param= new Param(count,"u_g",DOUBLEVEC);
	param->SetDoubleVec(ug,3*model->numberofnodes,3);
	parameters->AddObject(param);

	xfree((void**)&vx);
	xfree((void**)&vy);
	xfree((void**)&vz);
	xfree((void**)&ug);
	
	/*Assign output pointer: */
	*pparameters=parameters;
}
