/*!\file: CreateParametersControl.cpp
 * \brief driver for creating parameters dataset, for control analysis.
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateParameters"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../Model.h"

void CreateParametersControl(DataSet** pparameters,Model* model,ConstDataHandle model_handle){
	
	int i;
	
	DataSet* parameters=NULL;
	Param*   param = NULL;
	int      count;
	int      analysis_type;
	int      numberofdofspernode;

	double* fit=NULL;
	double* optscal=NULL;
	double* maxiter=NULL; 
	double* control_parameter=NULL;
	double* param_g=NULL;

	double* vx_obs=NULL;
	double* vy_obs=NULL;
	double* u_g_obs=NULL;

	double* vx=NULL;
	double* vy=NULL;
	double* vz=NULL;
	double* u_g=NULL;

	/*Get parameters: */
	parameters=*pparameters;
	count=parameters->Size();
	
	/*control_type: */
	count++;
	param= new Param(count,"control_type",STRING);
	param->SetString(model->control_type);
	parameters->AddObject(param);

	/*nsteps: */
	count++;
	param= new Param(count,"nsteps",INTEGER);
	param->SetInteger(model->nsteps);
	parameters->AddObject(param);

	/*tolx: */
	count++;
	param= new Param(count,"tolx",DOUBLE);
	param->SetDouble(model->tolx);
	parameters->AddObject(param);

	/*mincontrolconstraint: */
	count++;
	param= new Param(count,"mincontrolconstraint",DOUBLE);
	param->SetDouble(model->mincontrolconstraint);
	parameters->AddObject(param);

	/*maxcontrolconstraint: */
	count++;
	param= new Param(count,"maxcontrolconstraint",DOUBLE);
	param->SetDouble(model->maxcontrolconstraint);
	parameters->AddObject(param);
	
	/*epsvel: */
	count++;
	param= new Param(count,"epsvel",DOUBLE);
	param->SetDouble(model->epsvel);
	parameters->AddObject(param);
	
	/*meanvel: */
	count++;
	param= new Param(count,"meanvel",DOUBLE);
	param->SetDouble(model->meanvel);
	parameters->AddObject(param);

	/*Now, recover fit, optscal and maxiter as vectors: */
	ModelFetchData((void**)&model->fit,NULL,NULL,model_handle,"fit","Matrix","Mat");
	ModelFetchData((void**)&model->optscal,NULL,NULL,model_handle,"optscal","Matrix","Mat");
	ModelFetchData((void**)&model->maxiter,NULL,NULL,model_handle,"maxiter","Matrix","Mat");

	count++;
	param= new Param(count,"fit",DOUBLEVEC);
	param->SetDoubleVec(model->fit,model->nsteps);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"optscal",DOUBLEVEC);
	param->SetDoubleVec(model->optscal,model->nsteps);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"maxiter",DOUBLEVEC);
	param->SetDoubleVec(model->maxiter,model->nsteps);
	parameters->AddObject(param);

	xfree((void**)&model->fit);
	xfree((void**)&model->optscal);
	xfree((void**)&model->maxiter);

	/*Get vx, vx_obs, vy, vy_obs, and the parameter value: */
	ModelFetchData((void**)&vx,NULL,NULL,model_handle,"vx","Matrix","Mat");
	ModelFetchData((void**)&vy,NULL,NULL,model_handle,"vy","Matrix","Mat");
	ModelFetchData((void**)&vz,NULL,NULL,model_handle,"vz","Matrix","Mat");
	ModelFetchData((void**)&vx_obs,NULL,NULL,model_handle,"vx_obs","Matrix","Mat");
	ModelFetchData((void**)&vy_obs,NULL,NULL,model_handle,"vy_obs","Matrix","Mat");
	ModelFetchData((void**)&control_parameter,NULL,NULL,model_handle,model->control_type,"Matrix","Mat");

	u_g=(double*)xcalloc(model->numberofnodes*2,sizeof(double));
	if(vx)for(i=0;i<model->numberofnodes;i++)u_g[3*i+0]=vx[i]/model->yts;
	if(vy)for(i=0;i<model->numberofnodes;i++)u_g[3*i+1]=vy[i]/model->yts;
	if(vz)for(i=0;i<model->numberofnodes;i++)u_g[3*i+2]=vz[i]/model->yts;

	count++;
	param= new Param(count,"u_g",DOUBLEVEC);
	param->SetDoubleVec(u_g,3*model->numberofnodes,3);
	parameters->AddObject(param);

	u_g_obs=(double*)xcalloc(model->numberofnodes*2,sizeof(double));
	if(vx_obs)for(i=0;i<model->numberofnodes;i++)u_g_obs[2*i+0]=vx_obs[i]/model->yts;
	if(vy_obs)for(i=0;i<model->numberofnodes;i++)u_g_obs[2*i+1]=vy_obs[i]/model->yts;

	count++;
	param= new Param(count,"u_g_obs",DOUBLEVEC);
	param->SetDoubleVec(u_g_obs,2*model->numberofnodes,2);
	parameters->AddObject(param);
	
	param_g=(double*)xcalloc(model->numberofnodes*2,sizeof(double));
	for(i=0;i<model->numberofnodes;i++)param_g[2*i+0]=control_parameter[i];

	count++;
	param= new Param(count,"param_g",DOUBLEVEC);
	param->SetDoubleVec(param_g,2*model->numberofnodes,2);
	parameters->AddObject(param);

	xfree((void**)&vx);
	xfree((void**)&vy);
	xfree((void**)&vz);
	xfree((void**)&u_g);
	xfree((void**)&vx_obs);
	xfree((void**)&vy_obs);
	xfree((void**)&u_g_obs);
	xfree((void**)&param_g);
	xfree((void**)&control_parameter);

	/*Assign output pointer: */
	*pparameters=parameters;
}
