function md=loadresults(md,u_g,p_g,m_dh,m_ds,m_dhu);
%LOADRESULTS - load results onto model
%
%   The solution (vel,pressure,...) are on the g-set,
%   use index to get the value on each node
%
%   Usage:
%      md=Loadresults(md,u_g,p_g,m_dh,m_ds,m_dhu)

debug=m_dhu.parameters.debug;
dim=m_dhu.parameters.dim;
ishutter=m_dhu.parameters.ishutter;
ismacayealpattyn=m_dh.parameters.ismacayealpattyn;
isstokes=m_ds.parameters.isstokes;

if isnan(md.results), md.results=struct(); end 
if dim==2,
	results.step=1;
	results.time=1;
	results.vx=u_g(1:2:end)*md.yts;
	results.vy=u_g(2:2:end)*md.yts;
	results.vel=sqrt(results.vx.^2+results.vy.^2);
	results.pressure=p_g;
	md.results.diagnostic=results;

else
	
	results.step=1;
	results.time=1;
	if isstokes,
		results.vx=u_g(1:4:end)*md.yts;
		results.vy=u_g(2:4:end)*md.yts;
		results.vz=u_g(3:4:end)*md.yts;
		results.pressure=p_g;
	else
		results.vx=u_g(1:3:end)*md.yts;
		results.vy=u_g(2:3:end)*md.yts;
		results.vz=u_g(3:3:end)*md.yts;
		results.pressure=p_g;
	end
	results.vel=sqrt(results.vx.^2+results.vy.^2+results.vz.^2);
	md.results.diagnostic=results;
end
