function [analyses,numanalyses,solutioncore]=SolutionConfiguration(solutiontype),
%SOLUTIONCONFIGURATION - return type of analyses, number of analyses and solution_core function
%
%   Usage:
%      [analyses, numanalyses, solutioncore]=SolutionConfiguration(solutiontype);

%get solution_core string
solutioncore=CorePointerFromSolutionEnum(solutiontype);

switch solutiontype,

	case DiagnosticSolutionEnum,
		numanalyses=5;
		analyses=[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum];

	case SteadystateSolutionEnum,
		numanalyses=7; 
		analyses=[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum;ThermalAnalysisEnum;MeltingAnalysisEnum];

	case ThermalSolutionEnum,
		numanalyses=2; 
		analyses=[ThermalAnalysisEnum;MeltingAnalysisEnum];

	case PrognosticSolutionEnum,
		numanalyses=1; 
		analyses=[PrognosticAnalysisEnum];

	case BalancedthicknessSolutionEnum,
		numanalyses=1; 
		analyses=[BalancedthicknessAnalysisEnum];

	case BalancedvelocitiesSolutionEnum,
		numanalyses=1; 
		analyses=[BalancedvelocitiesAnalysisEnum];

	case SurfaceSlopeSolutionEnum,
		numanalyses=1; 
		analyses=[SurfaceSlopeAnalysisEnum];

	case BedSlopeSolutionEnum,
		numanalyses=1; 
		analyses=[BedSlopeAnalysisEnum];

	case Transient2DSolutionEnum,
		numanalyses=6; 
		analyses=[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum;PrognosticAnalysisEnum];

	case Transient3DSolutionEnum,
		numanalyses=8; 
		analyses=[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum;PrognosticAnalysisEnum;ThermalAnalysisEnum;MeltingAnalysisEnum];

	case FlaimSolutionEnum,
		numanalyses=1; 
		analyses=[FlaimAnalysisEnum];

	case GroundingLineMigration2DSolutionEnum,
		numanalyses=0; 
		analyses=[];

	otherwise
		error('%s%s%s',' solution type: ',EnumToString(solutiontype),' not supported yet!');

end
