/*! \file KML_Feature.h 
 *  \brief: header file for kml_feature abstract object
 */

#ifndef _KML_FEATURE_H_
#define _KML_FEATURE_H_

#define KML_FEATURE_NAME_LENGTH         81
#define KML_FEATURE_SNIPPET_LENGTH     161
#define KML_FEATURE_DESCRIPT_LENGTH   3201
#define KML_FEATURE_STYLEURL_LENGTH     81

/*Headers:*/
/*{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./KML_Object.h"
class KML_Style;
class DataSet;
/*}}}*/

class KML_Feature: public KML_Object {

	public:

		char  name[KML_FEATURE_NAME_LENGTH];
		bool  visibility;
		bool  open;
		char  snippet[KML_FEATURE_SNIPPET_LENGTH];
		char  descript[KML_FEATURE_DESCRIPT_LENGTH];
		char  styleurl[KML_FEATURE_STYLEURL_LENGTH];
		DataSet* style;

		/*KML_Feature constructors, destructors {{{1*/
		KML_Feature();
		~KML_Feature();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		void  Write(FILE* fid,char* indent);
		int   Id();
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/

};
#endif  /* _KML_FEATURE_H */

