/* \file IoModel.h
 * \brief  Header file defining the IoModel structure that will help in processing the input data coming 
 * into ISSM, from Matlab, or through a binary file opened for reading.
 * \sa IoModel.cpp
 */

#ifndef _IOMODEL_H
#define _IOMODEL_H

#include "../include/include.h"

class IoModel {

	public:

		/*Data: {{{1*/
		char*   name;
		char*	  inputfilename;
		char*	  outputfilename;
		char*   repository;
		int     dim;
		int     qmu_analysis;
		int     control_analysis;

		/*2d mesh: */
		int     numberofelements;
		int     numberofvertices;
		double* x;
		double* y;
		double* z;
		double* elements;
		double* elements_type;
		double* vertices_type;
		double* elementconnectivity;

		/*3d mesh: */
		int     numberofvertices2d;
		int     numberofelements2d;
		double* elements2d;
		int     numlayers;
		double* upperelements;
		double* lowerelements;

		/*elements type: */
		int     ishutter;
		int     ismacayealpattyn;
		int     isstokes;
		double* gridonhutter;
		double* gridonmacayeal;
		double* gridonpattyn;

		/*results: */
		double* vx;
		double* vy;
		double* vz;
		double* pressure;
		double* temperature;

		/*i/o: */
		int    io_gather;

		/*observations: */
		double*  thickness_obs;
		double*  vx_obs;
		double*  vy_obs;
		double*  vz_obs;

		/*qmu: */
		int      numberofvariables;
		int      numvariabledescriptors;
		int      numberofresponses;
		int      numresponsedescriptors;
		int      qmu_npart;

		/*geometry: */
		double* elementonbed;
		double* elementonsurface;
		double* gridonbed;
		double* gridonsurface;
		double* gridonstokes;
		double* borderstokes;
		double* thickness;
		double* thickness_coeff;
		double* surface;
		double* bed;
		double* bathymetry;
		double* elementoniceshelf;
		double* elementonwater;
		double* gridonicesheet;
		double* gridoniceshelf;
		double* gridonwater;

		/*friction: */
		int     drag_type;
		double* drag_coefficient;
		double* drag_p;
		double* drag_q;

		/*boundary conditions: */
		int     numberofpressureloads;
		double* pressureload;
		double* spcvelocity;
		double* spctemperature;
		double* spcthickness;
		double* spcwatercolumn;
		double* geothermalflux;
		int     numberofedges;
		double* edges;

		/*materials: */
		double  rho_water,rho_ice;
		double  g;
		double* rheology_B;
		double* rheology_n;

		/*numerical parameters: */
		double  meanvel;
		double  epsvel;
		int     artdiff;
		int     prognostic_DG;
		double  viscosity_overshoot;
		double  stokesreconditioning;
		int     shelf_dampening;
		double  cm_noisedmp;
		double* cm_min;
		double* cm_max;
		int     cm_gradient;;

		double  cm_noisedampening;

		/*control methods: */
		int      num_control_type;
		double*  control_type;

		/*solution parameters: */
		double* cm_responses;
		double* weights;
		double* cm_jump;
		int     nsteps;
		double  eps_cm;
		double  tolx;
		double* maxiter;
		int     verbose;
		int     output_frequency;
		double  eps_res;
		double  eps_rel;
		double  eps_abs;
		double  max_nonlinear_iterations;
		double  dt,ndt;
		int     time_adapt;
		double  cfl_coefficient;
		int     hydrostatic_adjustment;
		double  penalty_offset;
		double  penalty_melting;
		int     penalty_lock;
		double  sparsity;
		int     connectivity;
		int     lowmem;
		double* optscal;
		double  yts;
		double  waitonlock;
		int     kff;

		/*thermal parameters: */
		double beta;
		double hydro_gamma;
		double hydro_kn;
		double meltingpoint;
		double latentheat;
		double  heatcapacity,thermalconductivity;
		int    min_thermal_constraints;
		int    min_mechanical_constraints;
		int    stabilize_constraints;
		double mixed_layer_capacity;
		double thermal_exchange_velocity;

		/*rifts: */
		int      numrifts;
		double*  riftinfo;

		/*penalties: */
		int      numpenalties;
		double*  penalties;

		/*basal: */
		double*  melting_rate;
		double*  watercolumn;
		double   gl_melting_rate;
		double*  melting_rate_correction;
		int      melting_rate_correction_apply;
		double*  accumulation_rate;
		double*  dhdt;

		/*parameter output: */
		int      numoutput;

		/*qmu: */
		int      qmu_mass_flux_num_profiles;
		int      qmu_save_femmodel;

		/*grounding line migration: */
		int      gl_migration;

		/*exterior partitioning data, to be carried around: */
		bool*   my_elements;
		bool*   my_nodes;
		int*    my_vertices;
		int*    singlenodetoelementconnectivity;
		int*    numbernodetoelementconnectivity;
		int     nodecounter; //keep track of how many nodes are being created in each analysis type
		int     loadcounter; //keep track of how many loads are being created in each analysis type
		int     constraintcounter; //keep track of how many constraints are being created in each analysis type
		/*}}}*/
		/*Methods: {{{1*/
		~IoModel();
		IoModel();
		IoModel(ConstDataHandle iomodel_handle);
		void IoModelInit(void);
		void Echo(int which_part,int rank);
		/*}}}*/

};

#endif  /* _IOMODEL_H */
