/*!\file KMLMeshWritex
 */

#include "./KMLMeshWritex.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void KMLMeshWritex(int* ierror,
				   char* name,
				   char* notes,
				   int* elem,int melem,int nelem,
				   int* nodecon,int mncon,int nncon,
				   double* lat, double* lng,
				   int* part,
				   double* data, int mdata, int ndata,
				   double* cmap, int mcmap, int ncmap,
				   FILE* fid){

	int     i,j,k,ipt=0,jpt=0,nnodes;
	int     mxepg=25;
	int     lwidth=1;
	double  popac=0.50;
	char    indent[81]="  ";
	double* edata=NULL;
	bool    ncfree=false,
			edfree=false;
	KML_Document*  kdoc=NULL;
	KML_Style*     kstyle;
	KML_LineStyle* klsty;
	KML_PolyStyle* kpsty;

	clock_t clock0,clock1,clock0a,clock0b,clock0c;
	time_t  time0, time1, time0a, time0b, time0c;

	clock0=clock();
	time0 =time(NULL);
	_printf_(true,"\nKMLMeshWritex Module -- %s",ctime(&time0));

/*  construct kml document  */

	kdoc=new KML_Document();
	sprintf(kdoc->name      ,"ISSM Mesh: %s",name);
	kdoc->open      =1;
	sprintf(kdoc->descript  ,"%s",notes);

/*  write style templates for defaults and for each color of the matlab
	colormap (note that matlab colormap format is rgb, where each varies
	from 0 to 1, whereas the kml color format is aabbggrr, where each
	varies from 00 to ff.)  */

	klsty=new KML_LineStyle();
	sprintf(klsty->color     ,"ff000000");
	sprintf(klsty->colormode ,"normal");
	klsty->width     =lwidth;
	kpsty=new KML_PolyStyle();
	sprintf(kpsty->color     ,"%02xffffff",(int)floor(popac*255+0.5));
	sprintf(kpsty->colormode ,"random");
	kstyle=new KML_Style();
	sprintf(kstyle->id        ,"BlackLineRandomPoly");
	kstyle->line      =klsty;
	kstyle->poly      =kpsty;
	(kdoc->style     )->AddObject((Object*)kstyle);

	klsty=new KML_LineStyle();
	sprintf(klsty->color     ,"ff000000");
	sprintf(klsty->colormode ,"normal");
	klsty->width     ,lwidth;
	kpsty=new KML_PolyStyle();
	sprintf(kpsty->color     ,"00ffffff");
	sprintf(kpsty->colormode ,"random");
	kstyle=new KML_Style();
	sprintf(kstyle->id        ,"BlackLineEmptyPoly");
	kstyle->line      =klsty;
	kstyle->poly      =kpsty;
	(kdoc->style     )->AddObject((Object*)kstyle);

	klsty=new KML_LineStyle();
	sprintf(klsty->color     ,"ff0000ff");
	sprintf(klsty->colormode ,"normal");
	klsty->width     =lwidth;
	kpsty=new KML_PolyStyle();
	sprintf(kpsty->color     ,"%02x0000ff",(int)floor(popac*255+0.5));
	sprintf(kpsty->colormode ,"random");
	kstyle=new KML_Style();
	sprintf(kstyle->id        ,"RedLineRedPoly");
	kstyle->line      =klsty;
	kstyle->poly      =kpsty;
	(kdoc->style     )->AddObject((Object*)kstyle);

	if (cmap) {
		_printf_(true,"Writing %d Matlab colors as KML style templates.\n",mcmap);
		ipt=0;
		for (i=0; i<mcmap; i++) {
			klsty=new KML_LineStyle();
			sprintf(klsty->color     ,"ff000000");
			sprintf(klsty->colormode ,"normal");
			klsty->width     =lwidth;
			kpsty=new KML_PolyStyle();
			sprintf(kpsty->color     ,"%02x%02x%02x%02x",
					(int)floor(popac*255+0.5),
					(int)floor(cmap[ipt+2]*255+0.5),
					(int)floor(cmap[ipt+1]*255+0.5),
					(int)floor(cmap[ipt  ]*255+0.5));
			sprintf(kpsty->colormode ,"normal");
			kstyle=new KML_Style();
			sprintf(kstyle->id        ,"MatlabColor%d",i+1);
			kstyle->line      =klsty;
			kstyle->poly      =kpsty;
			(kdoc->style     )->AddObject((Object*)kstyle);
			ipt+=ncmap;
		}
	}
//	kdoc->DeepEcho();

/*  create the node connectivity table, if necessary
	(noting that rows do not need to be sorted, since the elements
	are consecutively numbered)  */

	if (!nodecon) {
		_printf_(true,"Creating the node connectivity table.\n");
		nncon=mxepg+1;
		nodecon=(int *) xcalloc(mncon*nncon,sizeof(int));
		ncfree=true;

		jpt=0;
		for (i=0; i<melem; i++) {
			for (j=0; j<nelem; j++) {
				if (elem[jpt]) {
					ipt=(elem[jpt]-1)*nncon;
					if (nodecon[ipt+(nncon-1)] < mxepg) {
						nodecon[ipt+nodecon[ipt+(nncon-1)]]=i+1;
						nodecon[ipt+(nncon-1)]++;
					}
					else
						_error_("Nodal connectivity table needs more than specified %d columns.\n",mxepg);
				}
				jpt++;
			}
		}
	}

/*  average nodal data to element data, if necessary
	(noting that multiple columns of data are handled here, but not
	yet below)  */

	if (data) {
		if      (mdata == melem)
			edata=data;

		else if (mdata == mncon) {
			_printf_(true,"Averaging nodal data to element data.\n");
			edata=(double *) xcalloc(melem*ndata,sizeof(double));
			edfree=true;

			ipt=0;
			jpt=0;
			for (i=0; i<melem; i++) {
				nnodes=0;
				for (j=0; j<nelem; j++) {
					if (elem[jpt]) {
						for (k=0; k<ndata; k++)
							edata[ipt+k]+=data[(elem[jpt]-1)*ndata+k];
						nnodes++;
					}
					jpt++;
				}
				if (nnodes)
					for (k=0; k<ndata; k++)
						edata[ipt+k]/=(double)nnodes;
				ipt+=ndata;
			}
		}

		else
			_error_("Data matrix has incorrect number of %d rows.\n",mdata);
	}

/*  write folder for mesh  */

	(kdoc ->feature   )->AddObject((Object*)KMLMeshElem(elem,melem,nelem,
														nodecon,mncon,nncon,
														lat,lng,
														edata,
														cmap,mcmap,ncmap));

	if (edfree) xfree((void**)&edata);
	if (ncfree) xfree((void**)&nodecon);
	clock0a=clock();
	time0a =time(NULL);
	_printf_(true,"  Constructed kml document -- %f CPU seconds; %f elapsed seconds.\n\n",
			 ((double)(clock0a-clock0))/CLOCKS_PER_SEC,difftime(time0a,time0));

/*  write kml file  */

	_printf_(true,"Writing kml document to file.\n");
	fprintf(fid,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
	fprintf(fid,"<kml xmlns=\"http://www.opengis.net/kml/2.2\">\n");
	kdoc->Write(fid,indent);
	fprintf(fid,"</kml>\n");
	clock0b=clock();
	time0b =time(NULL);
	_printf_(true,"  Wrote kml file -- %f CPU seconds; %f elapsed seconds.\n\n",
			 ((double)(clock0b-clock0a))/CLOCKS_PER_SEC,difftime(time0b,time0a));

	_printf_(true,"Deleting kml document.\n");
	delete kdoc;
	clock0c=clock();
	time0c =time(NULL);
	_printf_(true,"  Deleted kml document -- %f CPU seconds; %f elapsed seconds.\n\n",
			 ((double)(clock0c-clock0b))/CLOCKS_PER_SEC,difftime(time0c,time0b));

	clock1=clock();
	time1 =time(NULL);
	_printf_(true,"KMLMeshWritex Module -- %f CPU seconds; %f elapsed seconds.\n\n",
			 ((double)(clock1-clock0))/CLOCKS_PER_SEC,difftime(time1,time0));

	return;
}

KML_Folder* KMLMeshElem(int* elem,int melem,int nelem,
						int* nodecon,int mncon,int nncon,
						double* lat, double* lng,
						double* edata,
						double* cmap, int mcmap, int ncmap){

	int     i,j,ipt=0;
	double  alt=10000;
	double  cmin= DBL_MAX,
			cmax=-DBL_MAX;
	int     imap;
	KML_Folder*     kfold =NULL;
	KML_Placemark*  kplace=NULL;
	KML_Polygon*    kpoly =NULL;
	KML_LinearRing* kring =NULL;

/*  write folder for mesh  */

	kfold=new KML_Folder();
    sprintf(kfold->name      ,"Mesh");
	kfold->visibility=1;
	sprintf(kfold->descript  ,"Elements=%d, Grids=%d",melem,mncon);

	if (edata)
		for (i=0; i<melem; i++) {
			if (edata[i] < cmin)
				cmin=edata[i];
			if (edata[i] > cmax)
				cmax=edata[i];
		}

/*  write each element as a polygon placemark  */

	_printf_(true,"Writing %d tria elements as KML polygons.\n",melem);

	for (i=0; i<melem; i++) {
		kplace=new KML_Placemark();
		sprintf(kplace->name      ,"Element %d",(i+1));
		kplace->visibility=1;
		if (edata) {
//			sprintf(kplace->descript  ,"Element data: %g",edata[i]);
			sprintf(kplace->descript  ,"campaign{\n  deformation 1 %g quad_pol ascending right asap;\n}",edata[i]);
			imap = (int)floor((edata[i]-cmin)/(cmax-cmin)*mcmap+0.5)+1;
			if      ((imap >= 1) && (imap <= mcmap))
				sprintf(kplace->styleurl  ,"#MatlabColor%d",imap);
			else if (edata[i] == cmax)
				sprintf(kplace->styleurl  ,"#MatlabColor%d",mcmap);
			else
				sprintf(kplace->styleurl  ,"#BlackLineEmptyPoly");
		}
		else {
			sprintf(kplace->descript  ,"");
			sprintf(kplace->styleurl  ,"#BlackLineRandomPoly");
		}
//		kplace->DeepEcho();

		kpoly=new KML_Polygon();
		kpoly->extrude   =1;
		sprintf(kpoly->altmode   ,"relativeToGround");
//		kpoly->DeepEcho();

		kring=new KML_LinearRing();
		kring->ncoord    =nelem+1;
		kring->coords    =(double (*)[3]) xmalloc((nelem+1)*3*sizeof(double));

/*  write the nodal coordinates as a linear ring  */

		for (j=0; j<nelem; j++) {
			kring->coords[j][0]=lng[elem[ipt]-1];
			kring->coords[j][1]=lat[elem[ipt]-1];
			kring->coords[j][2]=alt;
			ipt++;
		}
		kring->coords[nelem][0]=kring->coords[0][0];
		kring->coords[nelem][1]=kring->coords[0][1];
		kring->coords[nelem][2]=kring->coords[0][2];
//		kring->DeepEcho();

/*  assemble the linear ring into polygon into placemark into folder  */

		(kpoly ->outer     )->AddObject((Object*)kring);
		(kplace->geometry  )->AddObject((Object*)kpoly);
		(kfold ->feature   )->AddObject((Object*)kplace);

//		if (!(int)fmod((double)(i+1),1000))
//			_printf_(true,"  %d tria elements written.\n",(i+1));
	}
	_printf_(true,"  %d tria elements written.\n",melem);

	return(kfold);
}
