function md=qmuparallel(md,varargin)
%QMUPARALLEL - drive qmu analysis in parallel
%
%   Usage:
%      md=qmuparallel(md);

%Get cluster.rc location
cluster_rc_location=which('cluster.rc');

%let solution sequences know that we are running in qmu mode
md.qmu_analysis=1;

%create dakota input file
md=qmuin(md,varargin{:});

%Figure out parameters for this particular cluster
[codepath,executionpath]=ClusterParameters(md.cluster,cluster_rc_location);

%Marshall model data into a binary file.
marshall(md);

%Create dakota input file.

%Now, we need to build the queuing script, used by the cluster to launch the job.
BuildQueueingScript(md,executionpath,codepath);

%Now, launch the queueing script
LaunchQueueJob(md,executionpath);

%Do we return, or just wait for results?
if md.waitonlock,
	%we wait for the done file
	waitonlock([executionpath '/' md.name '.lock']);
	%load results
	md=loadresultsfromcluster(md);
else
	return;
end

%reset qmu_analysis counter
md.qmu_analysis=0;
