/*!\file:  isdistributed.cpp
 * \brief: figure out if a dakota variable descriptor indicates presence of a distributed 
 * variable. For example: "rho_ice" is not distributed, but "thickness1" is. 
 * If variable is distributed, return root of the variable name (here, if would be "thickness" 
 * for variable descriptor "thickness1").
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include <ctype.h>
#include "../Alloc/alloc.h"

#undef __FUNCT__ 
#define __FUNCT__ "isdistributed"
int isdistributed(char** proot,char* name){

	int i;

	/*output: */
	int   distributed=0;
	char* root=NULL;

	/*intermediary: */
	for(i=0;i<strlen(name);i++){
		if (isdigit(name[i])){
			distributed=1;
			break;
		}
	}

	if(distributed){
		root=(char*)xmalloc((strlen(name)+1)*sizeof(char));
		strcpy(root,name);
	
		for(i=0;i<strlen(name);i++){
			if (isdigit(name[i])){
				root[i]='\0'; //finish the string here.
				break;
			}
		}
	}

	/*Assign output pointers:*/
	*proot=root;
	return distributed;
}

