/*!\file: CreateParametersQmu.cpp
 * \brief general driver for creating parameters dataset
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateParametersQmu"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../Model.h"

void CreateParametersQmu(DataSet** pparameters,Model* model,ConstDataHandle model_handle){
	
	int i;
	
	DataSet* parameters = NULL;
	Param*   param = NULL;
	int      count;
	
	int*     epart=NULL;
	int*     part=NULL;
	double*  dpart=NULL;
	int      elements_width;

	char**  responsedescriptors=NULL;
	char**  variabledescriptors=NULL;
	char*   descriptor=NULL;
	char*   tag=NULL;
	double* dakota_parameter=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	count=parameters->Size();

	//qmu analysis?
	count++;
	param= new Param(count,"qmu_analysis",INTEGER);
	param->SetInteger(model->qmu_analysis);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"qmu_npart",INTEGER);
	param->SetInteger(model->qmu_npart);
	parameters->AddObject(param);

	/*Deal with variables for qmu modeling: */
	variabledescriptors=(char**)xmalloc(model->numberofvariables*sizeof(char*));
	tag=(char*)xmalloc((strlen("variabledescriptori")+1)*sizeof(char));

	/*Fetch descriptors: */
	for(i=0;i<model->numberofvariables;i++){
		sprintf(tag,"%s%i","variabledescriptor",i);
		ModelFetchData((void**)&descriptor,NULL,NULL,model_handle,tag,"String",NULL);
		variabledescriptors[i]=descriptor;
	}

	/*Ok, we have all the variable descriptors. Build a parameter with it: */
	count++;
	param= new Param(count,"variabledescriptors",STRINGARRAY);
	param->SetStringArray(variabledescriptors,model->numberofvariables);
	parameters->AddObject(param);

	xfree((void**)&tag);

	/*Deal with responses and partition for qmu modeling: */
	responsedescriptors=(char**)xmalloc(model->numberofresponses*sizeof(char*));
	tag=(char*)xmalloc((strlen("responsedescriptori")+1)*sizeof(char));

	/*Fetch descriptors: */
	for(i=0;i<model->numberofresponses;i++){
		sprintf(tag,"%s%i","responsedescriptor",i);
		ModelFetchData((void**)&descriptor,NULL,NULL,model_handle,tag,"String",NULL);
		responsedescriptors[i]=descriptor;
	}

	/*Ok, we have all the response descriptors. Build a parameter with it: */
	count++;
	param= new Param(count,"responsedescriptors",STRINGARRAY);
	param->SetStringArray(responsedescriptors,model->numberofresponses);
	parameters->AddObject(param);

	
	#ifdef _PARALLEL_
	/*partition grids in model->qmu_npart parts: */

	if(strcmp(model->meshtype,"2d")==0){
		ModelFetchData((void**)&model->elements,NULL,NULL,model_handle,"elements","Matrix","Mat");
		elements_width=3; //tria elements
	}
	else{
		ModelFetchData((void**)&model->elements2d,NULL,NULL,model_handle,"elements2d","Matrix","Mat");
		elements_width=6; //penta elements
	}

	MeshPartitionx(&epart, &part,model->numberofelements,model->numberofnodes,model->elements, model->numberofelements2d,model->numberofnodes2d,model->elements2d,model->numlayers,elements_width, model->meshtype,model->qmu_npart);

	dpart=(double*)xmalloc(model->numberofnodes*sizeof(double));
	for(i=0;i<model->numberofnodes;i++)dpart[i]=part[i];

	count++;
	param= new Param(count,"qmu_part",DOUBLEVEC);
	param->SetDoubleVec(dpart,model->numberofnodes,1);
	parameters->AddObject(param);
	#endif

	/*Ok, now if any of the variables input from Dakota are distributed, we are going to need the parameters: */
	for(i=0;i<model->numberofvariables;i++){

		descriptor=variabledescriptors[i];

		if ((strcmp(descriptor,"thickness")==0) ||
			(strcmp(descriptor,"drag")     ==0)
			){

			//Fetch data: 
			ModelFetchData((void**)&dakota_parameter,NULL,NULL,model_handle,descriptor,"Matrix","Mat");

			//Add parameter
			count++;
			param= new Param(count,descriptor,DOUBLEVEC);
			param->SetDoubleVec(dakota_parameter,model->numberofnodes,1);
			parameters->AddObject(param);

			//free data
			xfree((void**)&dakota_parameter);

		}
	}

	/*Free data: */
	xfree((void**)&tag);
	for(i=0;i<model->numberofresponses;i++){
		char* descriptor=responsedescriptors[i];
		xfree((void**)&descriptor);
	}
	xfree((void**)&responsedescriptors);

	for(i=0;i<model->numberofvariables;i++){
		char* descriptor=variabledescriptors[i];
		xfree((void**)&descriptor);
	}
	xfree((void**)&variabledescriptors);

	xfree((void**)&model->elements);
	xfree((void**)&model->elements2d);
	xfree((void**)&epart);
	xfree((void**)&part);
	xfree((void**)&dpart);


	/*Assign output pointer: */
	*pparameters=parameters;
}
