/*!\file: CreateParametersPrognostic.cpp
 * \brief driver for creating parameters dataset, for prognostic analysis.
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateParametersPrognostic"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../Model.h"

void CreateParametersPrognostic(DataSet** pparameters,Model* model,ConstDataHandle model_handle){
	
	Param*   param = NULL;
	DataSet* parameters=NULL;
	int      count;
	int i;

	double* vx=NULL;
	double* vy=NULL;
	double* vz=NULL;
	double* u_g=NULL;
	double* pressure=NULL;
	double* thickness=NULL;
	double* accumulation=NULL;
	double* melting=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	count=parameters->Size();

	/*Get vx and vy: */
	ModelFetchData((void**)&vx,NULL,NULL,model_handle,"vx","Matrix","Mat");
	ModelFetchData((void**)&vy,NULL,NULL,model_handle,"vy","Matrix","Mat");
	ModelFetchData((void**)&vz,NULL,NULL,model_handle,"vz","Matrix","Mat");

	u_g=(double*)xcalloc(model->numberofnodes*3,sizeof(double));

	if(vx) for(i=0;i<model->numberofnodes;i++)u_g[3*i+0]=vx[i]/model->yts;
	if(vy) for(i=0;i<model->numberofnodes;i++)u_g[3*i+1]=vy[i]/model->yts;
	if(vz) for(i=0;i<model->numberofnodes;i++)u_g[3*i+2]=vz[i]/model->yts;

	count++;
	param= new Param(count,"u_g",DOUBLEVEC);
	param->SetDoubleVec(u_g,3*model->numberofnodes,3);
	parameters->AddObject(param);


	xfree((void**)&vx);
	xfree((void**)&vy);
	xfree((void**)&vz);
	xfree((void**)&u_g);
	
	/*Get thickness: */
	ModelFetchData((void**)&thickness,NULL,NULL,model_handle,"thickness","Matrix","Mat");
	
	count++;
	param= new Param(count,"h_g",DOUBLEVEC);
	if(thickness) param->SetDoubleVec(thickness,model->numberofnodes,1);
	else param->SetDoubleVec(thickness,0,0);
	parameters->AddObject(param);

	/*Free thickness: */
	xfree((void**)&thickness);

	/*Get melting: */
	ModelFetchData((void**)&melting,NULL,NULL,model_handle,"melting","Matrix","Mat");
	
	count++;
	param= new Param(count,"m_g",DOUBLEVEC);
	if(melting) param->SetDoubleVec(melting,model->numberofnodes,1);
	else param->SetDoubleVec(melting,0,1);
	parameters->AddObject(param);

	/*Free melting: */
	xfree((void**)&melting);

	/*Get accumulation: */
	ModelFetchData((void**)&accumulation,NULL,NULL,model_handle,"accumulation","Matrix","Mat");
	
	count++;
	param= new Param(count,"a_g",DOUBLEVEC);
	if(accumulation) param->SetDoubleVec(accumulation,model->numberofnodes,1);
	else param->SetDoubleVec(accumulation,0,0);
	parameters->AddObject(param);

	/*Free accumulation: */
	xfree((void**)&accumulation);




	/*Assign output pointer: */
	*pparameters=parameters;
}
