/*! \file KML_Object.h 
 *  \brief: header file for kml_object abstract object
 */

#ifndef _KML_OBJECT_H_
#define _KML_OBJECT_H_

#define KML_OBJECT_ID_LENGTH         81

/*Headers:{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "../Object.h"
/*}}}*/

class KML_Object: public Object {

	public:

		char  id[KML_OBJECT_ID_LENGTH];

		/*KML_Object constructors, destructors {{{1*/
		KML_Object();
		~KML_Object();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		int   Id();
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/

		/*virtual functions: */
		virtual void  Write(FILE* fid,char* indent)=0;


};
#endif  /* _KML_OBJECT_H */

