/*! \file KML_Folder.h 
 *  \brief: header file for kml_folder object
 */

#ifndef _KML_FOLDER_H_
#define _KML_FOLDER_H_

/*Headers:*/
/*{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./KML_Container.h"
class KML_Feature;
class DataSet;
/*}}}*/

class KML_Folder: public KML_Container {

	public:

		DataSet* feature;

		/*KML_Folder constructors, destructors {{{1*/
		KML_Folder();
		~KML_Folder();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		void  Write(FILE* fid,char* indent);
		int   Id();
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/

};
#endif  /* _KML_FOLDER_H */

