/*!\file KML_Folder.cpp
 * \brief: implementation of the kml_folder object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Folder::KML_Folder(){{{1*/
KML_Folder::KML_Folder(){

	feature   =new DataSet;

}
/*}}}*/
/*FUNCTION KML_Folder::~KML_Folder(){{{1*/
KML_Folder::~KML_Folder(){

	if (feature) {
		delete feature;
		feature   =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Folder::Echo {{{1*/
void  KML_Folder::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_Folder:\n");
	KML_Container::Echo();

	_printf_(flag,"       feature: (size=%d)\n" ,feature->Size());

	return;
}
/*}}}*/

/*FUNCTION KML_Folder::DeepEcho {{{1*/
void  KML_Folder::DeepEcho(){

	char  indent[81]="";

	KML_Folder::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Folder::DeepEcho {{{1*/
void  KML_Folder::DeepEcho(char* indent){

	int   i;
	char  indent2[81];
	bool  flag=true;

	_printf_(flag,"%sKML_Folder:\n",indent);
	KML_Container::DeepEcho(indent);

/*  loop over the features for the folder  */

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	if (feature->Size())
		for (i=0; i<feature->Size(); i++) {
			_printf_(flag,"%s       feature: [%d] begin\n" ,indent,i);
			((KML_Feature *)feature->GetObjectByOffset(i))->DeepEcho(indent2);
			_printf_(flag,"%s       feature: [%d] end\n"   ,indent,i);
		}
	else
		_printf_(flag,"%s       feature: [empty]\n"    ,indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Folder::Write {{{1*/
void  KML_Folder::Write(FILE* filout,char* indent){

	int   i;
	char  indent2[81];

	if (this->id && strlen(this->id))
		fprintf(filout,"%s<Folder id=\"%s\">\n",indent,this->id);
	else
		fprintf(filout,"%s<Folder>\n",indent);

	KML_Container::Write(filout,indent);

/*  loop over the features for the folder  */

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	for (i=0; i<feature->Size(); i++)
		((KML_Feature *)feature->GetObjectByOffset(i))->Write(filout,indent2);

	fprintf(filout,"%s</Folder>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Folder::Id {{{1*/
int   KML_Folder::Id(){
}
/*}}}*/

/*FUNCTION KML_Folder::MyRank {{{1*/
int   KML_Folder::MyRank(){
}
/*}}}*/

/*FUNCTION KML_Folder::Marshall {{{1*/
void  KML_Folder::Marshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_Folder::MarshallSize {{{1*/
int   KML_Folder::MarshallSize(){
}
/*}}}*/

/*FUNCTION KML_Folder::Demarshall {{{1*/
void  KML_Folder::Demarshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_Folder::Enum {{{1*/
int   KML_Folder::Enum(){
}
/*}}}*/

/*FUNCTION KML_Folder::copy {{{1*/
Object* KML_Folder::copy(){
}
/*}}}*/

