function outoptions=process_solve_options(options)
%DEFAULT_SOLVE_OPTIONS - set up default options for solve phase
%
%   Usage:
%      options=process_solve_options(options)
%
%   See also: SOLVE

%solution_type: check on this option, error out otherwise
solution_type=getfieldvalue(options,'analysis_type');

%batch mode for launching jobs.
outoptions.batch=getfieldvalue(options,'batch','no');

%directory 
outoptions.directory=getfieldvalue(options,'directory','');

%convert to Enum if a string was provided
if ischar(solution_type), error(['only Enums are supported as ''solution_type''. For example: md=solve(md,''solution_type'',DiagnosticSolutionEnum); ']); end

%check solution type is supported
if ~ismember(solution_type,[DiagnosticSolutionEnum,PrognosticSolutionEnum,ThermalSolutionEnum,...
		SteadystateSolutionEnum,ParametersSolutionEnum,Transient2DSolutionEnum,Transient3DSolutionEnum...
		BalancedthicknessSolutionEnum,BalancedvelocitiesSolutionEnum,BedSlopeSolutionEnum,SurfaceSlopeSolutionEnum,GroundingLineMigration2DSolutionEnum,HydrologySolutionEnum]),
	error(['process_solve_options error message: solution_type ' EnumToString(solution_type) ' not supported yet!']);
end
outoptions.solution_type=solution_type;
outoptions.upload=getfieldvalue(options,'upload','off');

%  process qmu arguments
outoptions.qmudir=getfieldvalue(options,'qmudir',['qmu' num2str(GetPId)]);  % qmudir =['qmu_' datestr(now,'yyyymmdd_HHMMSS')];
outoptions.qmufile=getfieldvalue(options,'qmufile','qmu');% qmufile cannot be changed unless ????script.sh is also changed
outoptions.overwrite=getfieldvalue(options,'overwrite','n');
outoptions.keep=getfieldvalue(options,'keep','n');
outoptions.ivar=getfieldvalue(options,'ivar',1);
outoptions.iresp=getfieldvalue(options,'iresp',1);
outoptions.imethod=getfieldvalue(options,'imethod',1);
outoptions.iparams=getfieldvalue(options,'iparams',1);
outoptions.runmpi=getfieldvalue(options,'runmpi',false);
