/*!\file: hydrology_core_step.cpp
 * \brief: core of the hydrology solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"

void hydrology_core_step(FemModel* femmodel,int step, double time){
	
	bool modify_loads=true;

	_printf_(VerboseSolution(),"   computing water column\n");
	femmodel->SetCurrentConfiguration(HydrologyAnalysisEnum);
	solver_nonlinear(femmodel,modify_loads);
	//solver_linear(femmodel);

	/*transfer water column thickness to old water column thickness: */
	InputDuplicatex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,WaterColumnEnum,OldWaterColumnEnum);

}
