/*!\file:  ElementMatrix.h
 * \brief container for information needed to plug element matrix generated by elements 
 * into the Kff and Kfs global matrices. 
 * This object will hold the element matrix on the g-set, the local as well as global 
 * dof lists in the f and s sets.
 */ 

#ifndef _ELEMENT_MATRIX_H_
#define _ELEMENT_MATRIX_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
class Node;
/*}}}*/

class ElementMatrix{

	public:
	
		int      nrows;
		int      ncols;
		bool     dofsymmetrical;
		bool     kff;
		double*  values;

		//gset
		int*     gglobaldoflist;

		/*row wise: */
		//fset
		int      row_fsize;
		int*     row_flocaldoflist;
		int*     row_fglobaldoflist;
		//sset
		int      row_ssize;
		int*     row_slocaldoflist;
		int*     row_sglobaldoflist;

		/*column wise: */
		//fset
		int      col_fsize;
		int*     col_flocaldoflist;
		int*     col_fglobaldoflist;
		//sset
		int      col_ssize;
		int*     col_slocaldoflist;
		int*     col_sglobaldoflist;

		/*ElementMatrix constructors, destructors {{{1*/
		ElementMatrix();
		ElementMatrix(ElementMatrix* Ke);
		ElementMatrix(ElementMatrix* Ke1,ElementMatrix* Ke2);
		ElementMatrix(ElementMatrix* Ke1,ElementMatrix* Ke2,ElementMatrix* Ke3);
		ElementMatrix(Node** nodes,int numnodes,Parameters* parameters,int approximation=NoneApproximationEnum);
		~ElementMatrix();
		/*}}}*/
		/*ElementMatrix specific routines {{{1*/
		void AddToGlobal(Mat Kgg, Mat Kff, Mat Kfs);
		void Echo(void);
		void CheckConsistency(void);
		void Transpose(void);
		void Init(ElementMatrix* Ke);
		void SetDiag(double scalar);
		/*}}}*/
};
#endif //#ifndef _ELEMENT_MATRIX_H_
