function md=solve(md,varargin)
%SOLVE - apply solution sequence for this model
%
%   Usage:
%      md=solve(md,varargin)
%      where varargin is a lit of paired arguments of string OR enums
%      arguments can be: 'analysis_type': 'DiagnosticAnalysis','ThermalAnalysis','PrognosticAnalysis','Transient2DAnalysis'
%
%   Examples:
%      md=solve(md,'analysis_type',DiagnosticSolutionEnum);

%recover options
options=pairoptions(varargin{:});

%add default options
options=process_solve_options(options);

%recover some fields
md.solution_type=options.solution_type;

%check model consistency
disp('checking model consistency');
ismodelselfconsistent(md),

%if running qmu analysis, some preprocessing of dakota files using 
%models fields needs to be carried out. 
if md.qmu_analysis,
	md=preqmu(md,options);
end

%preprocesses model before solving
md=presolve(md);

%Save model as is (in case of a crash)
assignin('base',inputname(1),md);

%If running in parallel, we have a different way of launching the solution
%sequences. 
if ~strcmpi(md.cluster.name,'none'),
	md=solveparallel(md,options);
	return;
end

%Launch correct solution sequence
md=issm(md,md.solution_type);

%post processes qmu results if necessary
if md.qmu_analysis,
	md=postqmu(md);
	cd ..
	if ~strncmpi(options.keep,'y',1)
		system(['rm -rf qmu' num2str(GetPId)]);
	end
end

%Check result is consistent
disp('checking result consistency');
%if ~isresultconsistent(md,options.solution_type),
%	disp('!! results not consistent correct the model !!') %it would be very cruel to put an error, it would kill the computed results (even if not consistent...)
%end

%convert analysis type to string finally
md.solution_type=EnumToString(options.solution_type);
