/*!\file ProcessParamsx
 * \brief: process parameters using partitioning vector
 */

#include "./ProcessParamsx.h"

#undef __FUNCT__ 
#define __FUNCT__ "ProcessParamsx"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void ProcessParamsx( DataSet* parameters, Vec  part){

	int i;
	
	double* partition=NULL;
	Param*  param=NULL;

	/*diagnostic: */
	double* vx=NULL;
	double* vy=NULL;
	double* vz=NULL;
		
	double* u_g=NULL;
	
	/*control: */
	Vec     vec_vx_obs=NULL;
	Vec     vec_vy_obs=NULL;
	Vec     vec_control_parameter=NULL;

	double* vx_obs=NULL;
	double* vy_obs=NULL;
	double* control_parameter=NULL;
	double* param_g=NULL; 

	double* u_g_obs=NULL;

	/*thermal*/ 
	double* pressure=NULL; 
	double* temperature=NULL; 
	double* melting=NULL; 
	
	double* p_g=NULL; 
	double* t_g=NULL; 
	double* m_g=NULL;

	/*prognostic: */
	double* a_g=NULL;
	double* h_g=NULL;
	double* accumulation=NULL;
	double* thickness=NULL;

	/*diverse: */
	int     numberofnodes;
	int     analysis_type;
	int     sub_analysis_type;
	int     count;

	parameters->FindParam((void*)&analysis_type,"analysis_type");
	parameters->FindParam((void*)&sub_analysis_type,"sub_analysis_type");
	count=parameters->Size();
		
	parameters->FindParam((void*)&numberofnodes,"numberofnodes");

	/*First serialize partition vector: */
	if(part)VecToMPISerial(&partition,part);
	
	if (   (analysis_type==ControlAnalysisEnum()) ||  
		   (analysis_type==DiagnosticAnalysisEnum()) || 
		   (analysis_type==ThermalAnalysisEnum()) ||
		   (analysis_type==PrognosticAnalysisEnum()) 
		   ){

		parameters->FindParam((void*)&vx,"vx");
		parameters->FindParam((void*)&vy,"vy");
		parameters->FindParam((void*)&vz,"vz");

		if(numberofnodes){
			u_g=(double*)xcalloc(numberofnodes*3,sizeof(double));

			if(vx){
				for(i=0;i<numberofnodes;i++){
					u_g[(int)(3*partition[i]+0)]=vx[i];  
				}
			}
			if(vy){
				for(i=0;i<numberofnodes;i++){
					u_g[(int)(3*partition[i]+1)]=vy[i];  
				}
			}
			if(vz){
				for(i=0;i<numberofnodes;i++){
					u_g[(int)(3*partition[i]+2)]=vz[i];  
				}
			}

			/*Now, create new parameters: */
			count++;
			param= new Param(count,"u_g",DOUBLEVEC);
			param->SetDoubleVec(u_g,3*numberofnodes);
			parameters->AddObject(param);

			/*erase old parameters: */
			param=(Param*)parameters->FindParamObject("vx");
			parameters->DeleteObject((Object*)param);

			param=(Param*)parameters->FindParamObject("vy");
			parameters->DeleteObject((Object*)param);

			param=(Param*)parameters->FindParamObject("vz");
			parameters->DeleteObject((Object*)param);
		}
	}

	if(analysis_type==ControlAnalysisEnum()){

		parameters->FindParam((void*)&vx_obs,"vx_obs");
		parameters->FindParam((void*)&vy_obs,"vy_obs");
		parameters->FindParam((void*)&control_parameter,"control_parameter");

		/*Now, from vx_obs and vy_obs, build u_g_obs, correctly partitioned: */

		u_g_obs=(double*)xcalloc(numberofnodes*2,sizeof(double));
		param_g=(double*)xcalloc(numberofnodes*2,sizeof(double));

		for(i=0;i<numberofnodes;i++){
			u_g_obs[(int)(2*partition[i]+0)]=vx_obs[i];  
			u_g_obs[(int)(2*partition[i]+1)]=vy_obs[i];  
			param_g[(int)(2*partition[i]+0)]=control_parameter[i];
		}

		/*Now, create new parameters: */
		count++;
		param= new Param(count,"u_g_obs",DOUBLEVEC);
		param->SetDoubleVec(u_g_obs,2*numberofnodes);
		parameters->AddObject(param);

		count++;
		param= new Param(count,"param_g",DOUBLEVEC);
		param->SetDoubleVec(param_g,2*numberofnodes);
		parameters->AddObject(param);

		/*erase old parameter: */
		param=(Param*)parameters->FindParamObject("vx_obs");
		parameters->DeleteObject((Object*)param);

		param=(Param*)parameters->FindParamObject("vy_obs");
		parameters->DeleteObject((Object*)param);

		param=(Param*)parameters->FindParamObject("control_parameter");
		parameters->DeleteObject((Object*)param);
	}

	if(analysis_type==ThermalAnalysisEnum()){

		parameters->FindParam((void*)&pressure,"pressure");

		/*Now, from temperature and melting, build t_g and m_g, correctly partitioned: */ 
		p_g=(double*)xcalloc(numberofnodes,sizeof(double));

		for(i=0;i<numberofnodes;i++){ 
			p_g[(int)(partition[i])]= pressure[i];  
		} 

		/*Now, create new parameter: */ 
		count++;
		param= new Param(count,"p_g",DOUBLEVEC);
		param->SetDoubleVec(p_g,numberofnodes);
		parameters->AddObject(param);

		/*erase old parameter: */ 
		param=(Param*)parameters->FindParamObject("pressure");
		parameters->DeleteObject((Object*)param);

		if (sub_analysis_type==TransientAnalysisEnum()){

			parameters->FindParam((void*)&temperature,"temperature"); 

			/*Now, from temperature , build t_g , correctly partitioned: */ 
			t_g=(double*)xcalloc(numberofnodes,sizeof(double)); 

			for(i=0;i<numberofnodes;i++){ 
				t_g[(int)(partition[i])]=temperature[i]; 
			} 

			/*Now, create new parameter: */ 
			count++; 
			param= new Param(count,"t_g",DOUBLEVEC); 
			param->SetDoubleVec(t_g,numberofnodes); 
			parameters->AddObject(param); 

			/*erase old parameter: */ 
			param=(Param*)parameters->FindParamObject("temperature"); 
			parameters->DeleteObject((Object*)param); 
		}
	}

	if(analysis_type==MeltingAnalysisEnum() && sub_analysis_type==TransientAnalysisEnum()){

		parameters->FindParam((void*)&melting,"melting"); 

		/*Now, from melting , build m_g , correctly partitioned: */ 
		m_g=(double*)xcalloc(numberofnodes,sizeof(double)); 

		for(i=0;i<numberofnodes;i++){ 
			m_g[(int)(partition[i])]=melting[i]; 
		} 

		/*Now, create new parameter: */ 
		count++; 
		param= new Param(count,"m_g",DOUBLEVEC); 
		param->SetDoubleVec(m_g,numberofnodes); 
		parameters->AddObject(param); 

		/*erase old parameter: */ 
		param=(Param*)parameters->FindParamObject("melting"); 
		parameters->DeleteObject((Object*)param); 
	}

	if(analysis_type==PrognosticAnalysisEnum()){

		parameters->FindParam((void*)&melting,"melting");
		parameters->FindParam((void*)&thickness,"thickness");
		parameters->FindParam((void*)&accumulation,"accumulation");
		
		/*Now, from melting accumulation and thickness, build m_g, h_g, correctly partitioned: */
		m_g=(double*)xcalloc(numberofnodes,sizeof(double));
		h_g=(double*)xcalloc(numberofnodes,sizeof(double));
		a_g=(double*)xcalloc(numberofnodes,sizeof(double));

		for(i=0;i<numberofnodes;i++){
			m_g[(int)(partition[i])]= melting[i];  
			h_g[(int)(partition[i])]= thickness[i];  
			a_g[(int)(partition[i])]= accumulation[i];  
		}

		/*Now, create new parameter: */
		count++;
		param= new Param(count,"m_g",DOUBLEVEC);
		param->SetDoubleVec(m_g,numberofnodes);
		parameters->AddObject(param);

		count++;
		param= new Param(count,"h_g",DOUBLEVEC);
		param->SetDoubleVec(h_g,numberofnodes);
		parameters->AddObject(param);

		count++;
		param= new Param(count,"a_g",DOUBLEVEC);
		param->SetDoubleVec(a_g,numberofnodes);
		parameters->AddObject(param);

		/*erase old parameter: */
		param=(Param*)parameters->FindParamObject("melting");
		parameters->DeleteObject((Object*)param);
		
		param=(Param*)parameters->FindParamObject("thickness");
		parameters->DeleteObject((Object*)param);

		param=(Param*)parameters->FindParamObject("accumulation");
		parameters->DeleteObject((Object*)param);
	}
	xfree((void**)&partition);
	
	xfree((void**)&vx);
	xfree((void**)&vy);
	xfree((void**)&vz);
	xfree((void**)&u_g);

	xfree((void**)&vx_obs);
	xfree((void**)&vy_obs);
	xfree((void**)&param_g);
	xfree((void**)&pressure);
	xfree((void**)&control_parameter);
	xfree((void**)&u_g_obs);
	xfree((void**)&p_g); 
	xfree((void**)&a_g); 
	xfree((void**)&h_g); 
	xfree((void**)&m_g); 
}
