function pargenerate(filename,title,data_format,nlines,ncols,secant_lat,meridian_long,corner_north,corner_east,posting_north,posting_east)
%PARGENERATE generate parameter file for images ala Rignot
%
% Usage: 
%              pargenerate(filename,title,data_format,nlines,ncols,secant_lat,meridian_long,corner_north,corner_east,posting_north,posting_east)
%
%

fid=fopen(filename,'wt');

fprintf(fid,'%s\n','ISSM gridded dataset parameter file');
fprintf(fid,'%s%s\n','title : ',title);
fprintf(fid,'%s\n','DEM_projection :    PS');
fprintf(fid,'%s%s\n','data_format :   ',data_format);
fprintf(fid,'%s%d\n','width:      ',ncols);
fprintf(fid,'%s%d\n','nlines:     ',nlines);
fprintf(fid,'%s%g%s\n','PS_secant_lat:    ',secant_lat,'   decimal degrees');
fprintf(fid,'%s%g%s\n','PS_meridian_long:    ',meridian_long,'   decimal degrees');
fprintf(fid,'%s%g%s\n','PS_corner_north:    ',corner_north,'  m');
fprintf(fid,'%s%g%s\n','PS_corner_east:    ',corner_east,'   m');
fprintf(fid,'%s%g%s\n','PS_post_north:    ',posting_north,'   m');
fprintf(fid,'%s%g%s\n','PS_post_east:    ',posting_east,'   m');

fclose(fid);
