#!/bin/bash
#This bash script calls the nightlyrun.m matlab file to run our nightly test decks. 
#It then processes the results and sends an email to the Ice developpers.

#Some functions 
function today_date {
suffix=`date | awk '{printf("%s-%s-%s",$2,$3,$6);}'` 
echo $suffix;
}

#create ISSM variables
OLDISSM_DIR=$ISSM_DIR;
export ISSM_DIR="/u/wilkes-r1b/morlighe/svn/issm/trunk/cron/trunk"
ISSM_RELEASE="issm";

#Figure out today's date
today=`today_date`;
host_name=`hostname`;

#Erase previous code
rm -rf trunk

#Fetch svn code
svn checkout http://s383-rhat/issm/svn/issm/trunk
source $ISSM_DIR/etc/environment.sh

#Go to the issm directory
cd $ISSM_DIR

#install ISSM

#1: install some packages
cd externalpackages
cd mpich2
sh install.sh
cd ../petsc
sh install.sh
cd ../metis
sh install.sh
cd ../triangle
sh install.sh
cd $ISSM_DIR

#2: install automake and autoconf
cd devpackages
make
cd ..

#3: generate MakeFiles
sh scripts/automakererun.sh
sh config/linux64.sh

#4: compile ISSM
make -j 8
make install

#5: change issm.rc
cd etc
cat cluster.rc | sed -e "s/cluster_codepath=\/u\/wilkes-r1b\/larour\/Ice\/ice1.proto\/bin/cluster_codepath=\/u\/wilkes-r1b\/morlighe\/svn\/issm\/trunk\/cron\/trunk\/bin/g" | sed -e "s/cluster_executionpath=\/home\/larour\/Testing\/Execution/cluster_executionpath=\/u\/wilkes-r1b\/morlighe\/Execution/g"> cluster.bak
mv cluster.bak cluster.rc
cd ..

#Figure out mailing list
source cron/mailinglist

#Launch matlab and the nightly run script
matlab -nodisplay  > ./nightly.log << EOF 
startup
nightlyrun;
EOF

#Process log for errors 
cat nightly.log | grep ERROR > errors1.log
cat nightly.log | grep SUCCESS > errors2.log
cat nightly.log | grep NIGHTLYRUNTERMINATEDCORRECTLY > check.log
cat errors1.log errors2.log > errors.log
		
#Mail
ERRORS=`cat errors.log`
CHECK=`cat check.log`

#1: no result -> did not work
if [ `expr length "$ERRORS"`  = "0" ]; then
	for i in `echo $MAILINGLIST`
		do
			mail -s "Nightly runs of $ISSM_RELEASE on: $host_name. Date:$today. DID NOT WORK CORRECTLY" $i < nightly.log
		done
else

#2: nightly run stopped before the end
	if [ `expr length "$CHECK"`  = "0" ]; then
		for i in `echo $MAILINGLIST`
		do  
			mail -s "Nightly runs of $ISSM_RELEASE on: $host_name. Date:$today. STOPPED BEFORE THE END" $i < errors.log
		done

#3: everything worked
	else
		for i in `echo $MAILINGLIST`
		do  
			mail -s "Nightly runs of $ISSM_RELEASE on: $host_name. Date:$today." $i < errors.log
		done
	fi
fi

#Erase log and error logs
rm -rf nightly.log errors1.log errors2.log errors.log check.log

#Erase ice code
cd ..
rm -rf trunk/
