/*
 * CreateNodesBalancedthickness.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesBalancedthickness(Nodes** pnodes, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int  i,j;
	int  node_id;
	int  vertex_id;
	int  io_index;
	bool continuous_galerkin=true;

	/*DataSets: */
	Nodes*    nodes = NULL;

	/*Recover pointer: */
	nodes=*pnodes;

	/*Create nodes if they do not exist yet*/
	if(!nodes) nodes = new Nodes(NodesEnum);

	/*Continuous Galerkin partition of nodes: */
	if(iomodel->prognostic_DG) continuous_galerkin=false;
	NodesPartitioning(&iomodel->my_nodes,iomodel->my_elements,iomodel->my_vertices,iomodel,iomodel_handle,continuous_galerkin);

	/*Check in 3d*/
	if(iomodel->prognostic_DG && iomodel->dim==3) _error_("DG 3d not implemented yet");

	/*First fetch data: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->gridonsurface,NULL,NULL,iomodel_handle,"gridonsurface");
	IoModelFetchData(&iomodel->gridonicesheet,NULL,NULL,iomodel_handle,"gridonicesheet");
	IoModelFetchData(&iomodel->gridoniceshelf,NULL,NULL,iomodel_handle,"gridoniceshelf");
	IoModelFetchData(&iomodel->vertices_type,NULL,NULL,iomodel_handle,"vertices_type");
	IoModelFetchData(&iomodel->gridonwater,NULL,NULL,iomodel_handle,"gridonwater");

	if(continuous_galerkin){

		/*Build Nodes dataset (Continuous Galerkin)*/
		for (i=0;i<iomodel->numberofvertices;i++){

			if(iomodel->my_vertices[i]){

				/*Add node to nodes dataset: */
				nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i+1,i,iomodel,BalancedthicknessAnalysisEnum));

			}
		}
	}
	else{

		/*Build Nodes dataset -> 3 for each element (Discontinuous Galerkin)*/
		for (i=0;i<iomodel->numberofelements;i++){
			for (j=0;j<3;j++){

				if(iomodel->my_nodes[3*i+j]){ 

					//Get index of the vertex on which the current node is located
					vertex_id=(int)*(iomodel->elements+3*i+j); //(Matlab indexing)
					io_index=vertex_id-1;                      //(C indexing)
					_assert_(vertex_id>0 && vertex_id<=iomodel->numberofvertices);

					//Compute Node id
					node_id=iomodel->nodecounter+3*i+j+1;

					/*Add node to nodes dataset: */
					nodes->AddObject(new Node(node_id,node_id-1,vertex_id,io_index,iomodel,BalancedthicknessAnalysisEnum));

				}
			}
		}
	}

	/*Clean fetched data: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->gridonbed);
	xfree((void**)&iomodel->gridonsurface);
	xfree((void**)&iomodel->gridonicesheet);
	xfree((void**)&iomodel->gridonwater);
	xfree((void**)&iomodel->gridoniceshelf);
	xfree((void**)&iomodel->vertices_type);

	/*Assign output pointer: */
	*pnodes=nodes;
}
