function field=FillHole(index,x,y,field)
%FILLHOLE - fill mesh data that has holes in it (hole is defined by field==NaN). Get the nearest neighboors to fill the holes.
%
%   Usage:
%      surface=FillHole(index,x,y,surface)
%
%   Example:
%      md.surface=FillHole(md.elements,x,md.y,md.surface)
%

%some checks
if nargin~=4 | nargout~=1
	help FillHole
	error('FillHole error message: bad usage');
end

if length(x)~=length(y),
	error('plugdata error message: x and y should have the same length');
end


pos_hole=find(isnan(field));
pos_full=find(~isnan(field));

%reduce our field to not include any holes: 
field_noholes=field(pos_full);
x_noholes=x(pos_full);
y_noholes=y(pos_full);

for i=1:length(pos_hole)

	if (mod(i,100)==0),
		fprintf('\b\b\b\b\b\b\b%5.2f%s',i/length(pos_hole)*100,' %');
	end

	%search the grid on the closest to i, that is not in a hole either
	[d posd]=min(sqrt((x(pos_hole(i))-x_noholes).^2+(y(pos_hole(i))-y_noholes).^2));
	field(pos_hole(i))=field_noholes(posd);
end
