#!/bin/bash
#This bash script install everything that needs to be set up in ice (compilation, startup, SuiteSparse)
#Make sure that CONFIG is the right OS system
#config_linux32.mk for a 32 bits linux OS, 
#config_linux64.mk for a 64 bits linux OS,
#config_mac.mk for Mac OS X

CONFIG="config_linux64.mk"

#go to root
cd $ISSM_DIR
HERE=`pwd`;

#check that ISSM_DIR is correctly set up
if [ $HERE != $ISSM_DIR ]; then

	cd ..

	#.bashrc or .cshrc not correctly configured, display error message
	echo "
	******************************* .bashrc or .cshrc not correctly configured *******************************

	In order for ISSM to work correctly, you should add the following lines in your shell
	environment script (.bashrc or .cshrc). 
	
	#ISSM 
	export ISSM_DIR=` pwd `
	source $ISSM_DIR/etc/environment.sh
	
	**********************************************************************************************************
	"
else

	#1: install some packages
	cd externalpackages
	cd mpich2
	sh install.sh
	cd ../petsc
	sh install.sh
	cd ../metis
	sh install.sh
	cd ../triangle
	sh install.sh
	cd $ISSM_DIR

	#2: install automake and autoconf
	cd devpackages
	make
	cd ..

	#3: generate MakeFiles
	./reconfigure.sh
	./configure.sh

	#4: compile ISSM
	make
	make install

fi
