/*\file Solver.c
 *\brief: solver
 */

#include "./Solver.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Mat         Kff           = NULL;
	Vec         pf            = NULL;
	Vec         uf0           = NULL;
	Vec         uf            = NULL;
	Vec         df            = NULL;
	Parameters *parameters    = NULL;
	int         verbose;
	int         analysis_type;
	char        option[100];
	PetscTruth  flag;
	
	/*Matlab solver: */
	mxArray* array[2];
	char* matlabstring="-ksp_type matlab";

	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&SolverUsage);
	
	/*parameters: */
	FetchParams(&parameters,PARAMETERS);
	parameters->FindParam(&verbose,VerboseEnum);

	/*In serial mode, we have no set any petsc options, do it now: */
	#ifdef _SERIAL_
	parameters->FindParam(&analysis_type,AnalysisTypeEnum);
	PetscOptionsFromAnalysis(parameters,analysis_type);
	#endif
	
	/*Retrieve solver type: */
	PetscOptionsGetString(PETSC_NULL,"-ksp_type",&option[0],100,&flag);

	/*Fetch rest of data only if not running the matlab solver: */
	if (strcmp(option,"matlab")!=0){
	
		/*Input datasets: */
		FetchData(&Kff,KFF);
		FetchData(&pf,PF);
		FetchData(&uf0,UF0);
		FetchData(&df,DF);

		/*Core module: */
		Solverx(&uf, Kff, pf, uf0, df,parameters);

		/*Write output*/
		WriteData(UF,uf);
	}
	else{
		/*Matlab solver: */
		if (verbose) printf("   Solving\n");
		array[0]=KFF;
		array[1]=PF;
		mexCallMATLAB(1,UF,2,array,"mldivide");
	}

	/*Free ressources: */
	MatFree(&Kff);
	VecFree(&pf);
	VecFree(&uf0);
	VecFree(&uf);
	VecFree(&df);
	delete parameters;

	MODULEEND();

}

void SolverUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [uf] = %s(Kff,pf,uf0,df,parameters);\n",__FUNCT__);
	_printf_(true,"\n");
}
