/*
	SystemMatrices.h
*/

#ifndef _SYSTEMMATRICES_H
#define _SYSTEMMATRICES_H

/* local prototypes: */
void SystemMatricesUsage(void);

#include "../../c/modules/modules.h"
#include "../../c/Container/Container.h"
#include "../../c/shared/shared.h"
#include "../../c/EnumDefinitions/EnumDefinitions.h"

#undef __FUNCT__ 
#define __FUNCT__  "SystemMatrices"

/* serial input macros: */
#define ELEMENTS     (mxArray *)prhs[0]
#define NODES        (mxArray *)prhs[1]
#define VERTICES     (mxArray *)prhs[2]
#define LOADS        (mxArray *)prhs[3]
#define MATERIALS    (mxArray *)prhs[4]
#define PARAMETERS   (mxArray *)prhs[5]
#define KFLAG        (mxArray *)prhs[6]
#define PFLAG        (mxArray *)prhs[7]
#define PENALTYKFLAG (mxArray *)prhs[8]
#define PENALTYPFLAG (mxArray *)prhs[9]

/* serial output macros: */
#define KGG  (mxArray**)&plhs[0]
#define KFF  (mxArray**)&plhs[1]
#define KFS  (mxArray**)&plhs[2]
#define PG   (mxArray**)&plhs[3]
#define PF   (mxArray**)&plhs[4]
#define DG   (mxArray**)&plhs[5]
#define DF   (mxArray**)&plhs[6]
#define KMAX (mxArray**)&plhs[7]

/* serial arg counts: */
#undef NLHS
#define NLHS  8
#undef NRHS
#define NRHS  10

#endif  /* _SYSTEMMATRICES_H */
