function options=stokesoptions(varargin)
%STOKESOPTIONS - return STOKES multi-physics solver petsc options
%
%   Usage:
%      options=stokesoptions;

%retrieve options provided in varargin
arguments=pairoptions(varargin{:});

%default stokes options
PETSC_VERSION=petscversion();
if PETSC_VERSION==2,
	error('stokesoptions error message: multi-physics options not supported in Petsc 2');
end
if PETSC_VERSION==3,
	options={{'mat_type','mpiaij'},{'ksp_type','gmres'},{'pc_type','fieldsplit'},{'pc_field_split_type','multiplicative'},...
	{'fieldsplit_0_pc_type','asm'},{'fieldsplit_0_ksp_type','gmres'},{'fieldsplit_0_sub_pc_type','jacobi'},{'fieldsplit_0_pc_asm_overlap',2},...
	{'fieldsplit_1_pc_type','jacobi'},{'fieldsplit_1_ksp_type','preonly'},{'issm_option_solver','stokes'}};
end

%now, go through our arguments, and write over default options.
for i=1:size(arguments.list,1),
	arg1=arguments.list{i,1};
	arg2=arguments.list{i,2};
	found=0;
	for j=1:size(options,2),
		joption=options{j};
		if strcmpi(joption{1},arg1),
			joption{2}=arg2;
			options{j}=joption;
			found=1;
			break;
		end
	end
	if ~found,
		%this option did not exist, add it: 
		options{end+1}={arg1,arg2};
	end
end
