/*!\file: solver_linear.cpp
 * \brief: numerical core of linear solutions
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../modules/modules.h"

void solver_linear(FemModel* femmodel){

	/*intermediary: */
	Mat  Kgg = NULL, Kff = NULL, Kfs   = NULL;
	Vec  ug  = NULL, uf  = NULL;
	Vec  pg  = NULL, pf  = NULL;
	Vec dg  = NULL, df  = NULL;
	bool kffpartitioning;

	/*Recover parameters: */
	femmodel->parameters->FindParam(&kffpartitioning,KffEnum);

	if(kffpartitioning){
		SystemMatricesx(NULL,&Kff, &Kfs, NULL,&pf, NULL, &df, NULL,femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);
		Reduceloadx(pf, Kfs, femmodel->ys); MatFree(&Kfs);
	}
	else{
		SystemMatricesx(&Kgg, NULL, NULL, &pg,NULL, &dg, NULL, NULL,femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);
		Reducematrixfromgtofx(&Kff,&Kfs,Kgg,femmodel->nodesets); MatFree(&Kgg);
		Reduceloadfromgtofx(&pf, pg, Kfs, femmodel->ys, femmodel->nodesets);VecFree(&pg); MatFree(&Kfs);
		Reducevectorgtofx(&df, dg, femmodel->nodesets,femmodel->parameters); VecFree(&dg);
	}

	Solverx(&uf, Kff, pf, NULL, df, femmodel->parameters); MatFree(&Kff); VecFree(&pf); VecFree(&df);
	Mergesolutionfromftogx(&ug, uf,femmodel->ys,femmodel->nodesets);VecFree(&uf);
	InputUpdateFromSolutionx( femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,ug); VecFree(&ug); VecFree(&uf);
}
