#!/bin/bash

#get number of CPUS
NUMCPUS=$1;

#version of bbftp-client
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/bbftp-client-//g'`
echo $version

#Some cleanup
rm -rf src install bbftp-client-$version

#Create install directories
mkdir install src

#Untar 
tar -zxvf  bbftp-client-$version.tar.gz

#Move bbftp-client into install directory
mv bbftp-client-$version/* src
rm -rf bbftp-client-$version

#Apply patches
cd src 

#Configure
cd bbftpc
./configure --prefix=$ISSM_TIER/externalpackages/bbftp/install

#Compile bbftp-client
if [ -z $NUMCPUS ];
then
	make
else
	make -j $NUMCPUS
fi

make install
