function nightlyrun(varargin)
%NIGHTLYRUN - run the nighlty tests on 'tests/Verification'
%
%   This function goes to each directory of 'tests/Verifications' and
%   launch the nightly tests. A specific package can be given in input
%   only this package will be tested
%
%  Usage:
%      nightlyrun(varargin)
%
%   Example:
%      nightlyrun;
%      nightlyrun({'ice'});
%      nightlyrun({'cielo_serial','cielo_parallel'});

%use ISSM_DIR generated by startup.m
global ISSM_DIR

%Go to Test directory
eval(['cd ' ISSM_DIR '/test/']);

%Run all verification tests
cd Verification

%Get a list of the test decks
[status,list]=system('ls -l | grep -v CVS | grep -v cielo | awk ''{printf("%s|",$9);}'' '); %only works on *nix systems.
list=strsplit(list,'|');

%Go through list of decks, and run the deck runme.m files package by package.
packages={'macayeal','ice','cielo_serial','cielo_parallel'};
for i=1:length(packages),
	for j=2:length(list)-1,
		eval(['cd ' list{j}]);
		if nargin==1
			runme(varargin{1});
		else
			runme({packages{i}});
		end
		cd ..
	end
end

%display needed by nightlyrun.sh to check that no error popped up.
disp('NIGHTLYRUNTERMINATEDCORRECTLY');
