/*!\file: groundinglinemigration2d_core.cpp
 * \brief: core of the groundinglinemigration2d solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include <float.h>

void groundinglinemigration2d_core(FemModel* femmodel){


	/*intermediary: */
	int i;
	int    solution_type;
	
	/* recover parameters: */
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	/*activate formulation: */
	femmodel->SetCurrentConfiguration(PrognosticAnalysisEnum);

	_printf_(VerboseSolution(),"%s\n","   computing new grounding line position");
	GroundingLineMigrationx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);

	if(solution_type==GroundingLineMigration2DSolutionEnum){
		_printf_(VerboseSolution(),"%s\n","   saving results\n");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,ElementOnIceShelfEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,ThicknessEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,SurfaceEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,BedEnum);
	}
}
