function md=thermal(md)
%THERMAL - thermal solution sequence: steady state and transient
%
%   Usage:
%      md=thermal(md)

	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	displaystring(md.debug,'%s',['reading thermal model data']);
	md.analysis_type='thermal'; m_t=CreateFemModel(md);

	displaystring(md.debug,'%s',['reading melting model data']);
	md.analysis_type='melting'; m_m=CreateFemModel(md);

	% figure out number of dof: just for information purposes.
	md.dof=m_t.nodesets.fsize;

	%initialize inputs
	displaystring(md.debug,'\n%s',['setup inputs...']);
	inputs=inputlist;
	inputs=add(inputs,'velocity',m_t.parameters.u_g,'doublevec',3,m_t.parameters.numberofnodes);
	inputs=add(inputs,'pressure',m_t.parameters.p_g,'doublevec',1,m_t.parameters.numberofnodes);
	inputs=add(inputs,'dt',m_t.parameters.dt,'double');
	
	%call core
	results=thermal_core(m_t,m_m,inputs,md.sub_analysis_type);

	%plug onto the model
	md.results.thermal=results;

	%stop timing
	t2=clock;
	displaystring(md.debug,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);	
