function solution=thermal_core(m_t,m_m,inputs,sub_analysis_type)
%THERMAL_CORE - core of thermal solution
%
%   Usage:
%      solution=thermal_core(m_t,m_m,inputs,sub_analysis_type)


if strcmpi(sub_analysis_type,'steady'),

	displaystring(m_t.parameters.debug,'\n%s',['computing temperatures...']);
	[t_g m_t.loads melting_offset]=thermal_core_nonlinear(m_t,inputs,'thermal','steady');

	displaystring(m_t.parameters.debug,'\n%s',['computing melting...']);
	inputs=add(inputs,'melting_offset',melting_offset,'double');
	inputs=add(inputs,'temperature',t_g,'doublevec',1,m_t.parameters.numberofnodes);
	m_g=diagnostic_core_linear(m_m,inputs,'melting','steady');

	displaystring(m_t.parameters.debug,'\n%s',['load results...']);
	solution=struct('step',[],'time',[],'temperature',[],'melting',[]);
	solution.step=1;
	solution.time=0;
	solution.temperature=t_g;
	solution.melting=m_g*m_t.parameters.yts; %from m/s to m/a;

else

	%initialize temperature and melting
	t_g=m_t.parameters.t_g;
	m_g=m_m.parameters.m_g;
	nsteps=m_t.parameters.ndt/m_t.parameters.dt;

	%initialize temperature and melting
	soln.t_g=t_g;
	soln.m_g=m_g;
	soln.time=0;

	for n=1:nsteps, 

		displaystring(m_t.parameters.debug,'\n%s%i/%i\n','time step: ',n,nsteps);
		soln(n+1).time=n*m_t.parameters.dt;

		displaystring(m_t.parameters.debug,'\n%s',['    computing temperatures...']);
		inputs=add(inputs,'temperature',soln(n).t_g,'doublevec',1,m_t.parameters.numberofnodes);
		[soln(n+1).t_g m_t.loads melting_offset]=thermal_core_nonlinear(m_t,inputs,'thermal','transient');

		disp('   computing melting...');
		inputs=add(inputs,'temperature',soln(n).t_g,'doublevec',1,m_t.parameters.numberofnodes);
		inputs=add(inputs,'melting_offset',melting_offset,'double');
		soln(n+1).m_g=diagnostic_core_linear(m_m,inputs,'melting','transient');

	end

	%Wrap up
	solution=struct('step',{},'time',{},'temperature',{},'melting',{});
	for n=1:nsteps+1,
		solution(n).temperature=soln(n).t_g;
		solution(n).melting=soln(n).m_g*m_t.parameters.yts; %in m/year
		solution(n).time=soln(n).time/m_t.parameters.yts;         %in years
		solution(n).step=n;
	end
end
