/*!\file:  GroundingLineMigrationxLocal.h
 * \brief local header file for Grounding Line Migration
 */ 

#ifndef _GROUNDINGLINEMIGRATIONXLOCAL_H
#define _GROUNDINGLINEMIGRATIONXLOCAL_H

class Elements;
class Nodes;
class Parameters;

/* local prototypes: */

void AgressiveMigration(Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters);
void SoftMigration(Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters);

double* CreateElementOnIceShelf(Elements* elements);
bool*   CreateElementOnGroundingLine(Elements* elements,double* element_on_iceshelf);
double* CreateElementTouchingIceShelf(Elements* elements);
int     UpdateShelfStatus(Elements* elements,Nodes* nodes,Parameters* parameters,double* element_touching_iceshelf);

#endif  /* _GROUNDINGLINEMIGRATIONXLOCAL_H */
