function varargout=loadmodel(path)
%LOADMODEL - load a model using built-in load module
%
%   check that model prototype has not changed. if so, adapt to new model prototype.
%
%   Usage:
%      md=loadmodel(path)
%      loadmodel path

%check nargout
if nargout>1,
	error('loadmodel usage error: md=loadmodel(path)');
end
%check existence
if ~exist(path)
	error(['loadmodel error message: file ' path ' does not exist']);
end
%check that the file is readable
[stat,mess]=fileattrib(path);
if( stat==0 | mess.UserRead~=1),
	%error(['loadmodel error message: file ' path ' is not readable (permission denied).']);
end
%check number of variables
if length(whos('-file',path))>1,
	error(['loadmodel error message: file ' path ' contains several variables. Only one model should be present.']);
end

try,
	%recover model and name it md
	struc=struct(load(path,'-mat'));
	fieldname=char(fieldnames(struc));
	md=eval(['struc.' fieldname]);
	
	%now, transform md into a new model
	if ~strcmpi(class(md),'model'),
		md2=model;
		md2=structtomodel(md2,md);
		md=md2;
		clear md2;
	end
	if nargout,
		varargout{1}=md;
	else
		assignin('caller',fieldname,md);
	end
catch me
	disp(getReport(me))
	error(['could not load model ' path]);
end
