/*! \file Penta.h 
 *  \brief: header file for penta object
 */

#ifndef _PENTA_H_
#define _PENTA_H_

/*Headers:*/
/*{{{1*/
#include "./Element.h"
#include "./PentaHook.h"
#include "./PentaRef.h"
class  Object;
class Parameters;
class Inputs;
class IoModel;
class Node;
class Matice;
class Matpar;
class Tria;
class ElementMatrix;
class ElementVector;

#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
/*}}}*/

class Penta: public Element,public PentaHook,public PentaRef{

	public:

		int          id;
		int          sid;

		Node       **nodes;        // 6 nodes
		Matice      *matice;       // 1 material ice
		Matpar      *matpar;       // 1 material parameter
		Penta      **verticalneighbors;   // 2 neighbors: first one under, second one above
		int          horizontalneighborsids[3];

		Parameters  *parameters;   //pointer to solution parameters
		Inputs      *inputs;
		Results      *results;

		/*Penta constructors and destructor: {{{1*/
		Penta();
		Penta(int penta_id,int penta_sid,int i, IoModel* iomodel,int nummodels);
		~Penta();
		/*}}}*/
		/*Object virtual functions definitions: {{{1*/
		Object*   copy();
		void	  DeepEcho();
		void	  Demarshall(char** pmarshalled_dataset);
		void	  Echo();
		int		  Enum();
		int		  Id(); 
		void	  Marshall(char** pmarshalled_dataset);
		int		  MarshallSize();
		int		  MyRank();
		/*}}}*/
		/*Update virtual functions definitions: {{{1*/
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromSolution(double* solutiong);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVectorDakota(bool* vector, int name, int type);
		void  InputUpdateFromVectorDakota(double* vector, int name, int type);
		void  InputUpdateFromVectorDakota(int* vector, int name, int type);
		void  InputUpdateFromIoModel(int index, IoModel* iomodel);
		/*}}}*/
		/*Element virtual functions definitions: {{{1*/
		void   AverageOntoPartition(Vec partition_contributions,Vec partition_areas,double* vertex_response,double* qmu_part);
		void   ComputeBasalStress(Vec sigma_b);
		void   ComputeStrainRate(Vec eps);
		void   Configure(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters);
		void   SetCurrentConfiguration(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters);
		double RegularizeInversion(void);
		void   CreateKMatrix(Mat Kgg, Mat Kff, Mat Kfs);
		void   CreatePVector(Vec pg, Vec pf);
		void   DeleteResults(void);
		int    GetNodeIndex(Node* node);
		void   GetSolutionFromInputs(Vec solution);
		double GetZcoord(GaussPenta* gauss);
		void   GetVectorFromInputs(Vec vector,int NameEnum);
		void   Gradj(Vec gradient,int control_type);
		void   GradjB(Vec gradient);
		void   GradjDrag(Vec gradient);
		int    Sid();
		void   InputControlUpdate(double scalar,bool save_parameter);
		void   InputArtificialNoise(int enum_type,double min, double max);
		bool   InputConvergence(double* eps, int* enums,int num_enums,int* criterionenums,double* criterionvalues,int num_criterionenums);
		void   InputDepthAverageAtBase(int enum_type,int average_enum_type,int object_enum=ElementsEnum);
		void   InputDuplicate(int original_enum,int new_enum);
		void   InputScale(int enum_type,double scale_factor);
		void   ControlInputGetGradient(Vec gradient,int enum_type);
		void   ControlInputScaleGradient(int enum_type,double scale);
		void   ControlInputSetGradient(double* gradient,int enum_type);
		void   InputToResult(int enum_type,int step,double time);
		double MassFlux(double* segment,bool process_units);
		void   MaxAbsVx(double* pmaxabsvx, bool process_units);
		void   MaxAbsVy(double* pmaxabsvy, bool process_units);
		void   MaxAbsVz(double* pmaxabsvz, bool process_units);
		void   MaxVel(double* pmaxvel, bool process_units);
		void   MaxVx(double* pmaxvx, bool process_units);
		void   MaxVy(double* pmaxvy, bool process_units);
		void   MaxVz(double* pmaxvz, bool process_units);
		void   MigrateGroundingLine();
		void   MinVel(double* pminvel, bool process_units);
		void   MinVx(double* pminvx, bool process_units);
		void   MinVy(double* pminvy, bool process_units);
		void   MinVz(double* pminvz, bool process_units);
		double ThicknessAbsMisfit(bool process_units);
		double SurfaceAbsVelMisfit(bool process_units);
		double SurfaceRelVelMisfit(bool process_units);
		double SurfaceLogVelMisfit(bool process_units);
		double SurfaceLogVxVyMisfit(bool process_units);
		double SurfaceAverageVelMisfit(bool process_units);
		void   PatchFill(int* pcount, Patch* patch);
		void   PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes);
		void   ProcessResultsUnits(void);
		double SurfaceArea(void);
		void   Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type);
		int    UpdateShelfStatus(Vec new_shelf_nodes);
		void   UpdateShelfFlags(double* new_shelf_nodes);
		double TimeAdapt();
		int*   GetHorizontalNeighboorSids(void);
		/*}}}*/
		/*Penta specific routines:{{{1*/
		void	  BedNormal(double* bed_normal, double xyz_list[3][3]);
		ElementMatrix* CreateKMatrixBalancedthickness(void);
		ElementMatrix* CreateKMatrixBalancedvelocities(void);
		ElementMatrix* CreateKMatrixCouplingMacAyealPattyn(void);
		ElementMatrix* CreateKMatrixCouplingMacAyealPattynViscous(void);
		ElementMatrix* CreateKMatrixCouplingMacAyealPattynFriction(void);
		ElementMatrix* CreateKMatrixCouplingMacAyealStokes(void);
		ElementMatrix* CreateKMatrixCouplingMacAyealStokesViscous(void);
		ElementMatrix* CreateKMatrixCouplingMacAyealStokesFriction(void);
		ElementMatrix* CreateKMatrixCouplingPattynStokes(void);
		ElementMatrix* CreateKMatrixDiagnosticHoriz(void);
		ElementMatrix* CreateKMatrixDiagnosticHutter(void);
		ElementMatrix* CreateKMatrixDiagnosticMacAyeal2d(void);
		ElementMatrix* CreateKMatrixDiagnosticMacAyeal3d(void);
		ElementMatrix* CreateKMatrixDiagnosticMacAyeal3dViscous(void);
		ElementMatrix* CreateKMatrixDiagnosticMacAyeal3dFriction(void);
		ElementMatrix* CreateKMatrixDiagnosticMacAyealPattyn(void);
		ElementMatrix* CreateKMatrixDiagnosticMacAyealStokes(void);
		ElementMatrix* CreateKMatrixDiagnosticPattyn(void);
		ElementMatrix* CreateKMatrixDiagnosticPattynViscous(void);
		ElementMatrix* CreateKMatrixDiagnosticPattynFriction(void);
		ElementMatrix* CreateKMatrixDiagnosticPattynStokes(void);
		ElementMatrix* CreateKMatrixDiagnosticStokes(void);
		ElementMatrix* CreateKMatrixDiagnosticStokesViscous(void);
		ElementMatrix* CreateKMatrixDiagnosticStokesFriction(void);
		ElementMatrix* CreateKMatrixDiagnosticVert(void);
		ElementMatrix* CreateKMatrixDiagnosticVertVolume(void);
		ElementMatrix* CreateKMatrixDiagnosticVertSurface(void);
		ElementMatrix* CreateKMatrixMelting(void);
		ElementMatrix* CreateKMatrixPrognostic(void);
		ElementMatrix* CreateKMatrixSlope(void);
		ElementMatrix* CreateKMatrixThermal(void);
		ElementMatrix* CreateKMatrixThermalVolume(void);
		ElementMatrix* CreateKMatrixThermalShelf(void);
		ElementVector* CreatePVectorBalancedthickness(void);
		ElementVector* CreatePVectorBalancedvelocities(void);
		ElementVector* CreatePVectorAdjointHoriz(void);
		ElementVector* CreatePVectorAdjointMacAyeal(void);
		ElementVector* CreatePVectorAdjointPattyn(void);
		ElementVector* CreatePVectorCouplingMacAyealStokes(void);
		ElementVector* CreatePVectorCouplingMacAyealStokesViscous(void);
		ElementVector* CreatePVectorCouplingMacAyealStokesFriction(void);
		ElementVector* CreatePVectorCouplingPattynStokes(void);
		ElementVector* CreatePVectorCouplingPattynStokesViscous(void);
		ElementVector* CreatePVectorCouplingPattynStokesFriction(void);
		ElementVector* CreatePVectorDiagnosticHoriz(void);
		ElementVector* CreatePVectorDiagnosticHutter(void);
		ElementVector* CreatePVectorDiagnosticMacAyeal(void);
		ElementVector* CreatePVectorDiagnosticMacAyealPattyn(void);
		ElementVector* CreatePVectorDiagnosticMacAyealStokes(void);
		ElementVector* CreatePVectorDiagnosticPattyn(void);
		ElementVector* CreatePVectorDiagnosticPattynStokes(void);
		ElementVector* CreatePVectorDiagnosticStokes(void);
		ElementVector* CreatePVectorDiagnosticStokesViscous(void);
		ElementVector* CreatePVectorDiagnosticStokesShelf(void);
		ElementVector* CreatePVectorAdjointStokes(void);
		ElementVector* CreatePVectorDiagnosticVert(void);
		ElementVector* CreatePVectorDiagnosticVertVolume(void);
		ElementVector* CreatePVectorDiagnosticVertBase(void);
		ElementVector* CreatePVectorMelting(void);
		ElementVector* CreatePVectorPrognostic(void);
		ElementVector* CreatePVectorSlope(void);
		ElementVector* CreatePVectorThermal(void);
		ElementVector* CreatePVectorThermalVolume(void);
		ElementVector* CreatePVectorThermalShelf(void);
		ElementVector* CreatePVectorThermalSheet(void);
		void	  GetDofList(int** pdoflist,int approximation_enum,int setenum);
		void	  GetDofList1(int* doflist);
		void      GetSidList(int* sidlist);
		int     GetElementType(void);
		void    GetParameterListOnVertices(double* pvalue,int enumtype);
		void    GetParameterListOnVertices(double* pvalue,int enumtype,double defaultvalue);
		void    GetParameterValue(double* pvalue,Node* node,int enumtype);
		void	  GetPhi(double* phi, double*  epsilon, double viscosity);
		void	  GetSolutionFromInputsDiagnosticHoriz(Vec solutiong);
		void	  GetSolutionFromInputsDiagnosticHutter(Vec solutiong);
		void	  GetSolutionFromInputsDiagnosticStokes(Vec solutiong);
		void	  GetSolutionFromInputsDiagnosticVert(Vec solutiong);
		void	  GetSolutionFromInputsThermal(Vec solutiong);
		double GetStabilizationParameter(double u, double v, double w, double diameter, double rho_ice, double heatcapacity, double thermalconductivity);
		void    GetStrainRate3dPattyn(double* epsilon,double* xyz_list, GaussPenta* gauss, Input* vx_input, Input* vy_input);
		void    GetStrainRate3d(double* epsilon,double* xyz_list, GaussPenta* gauss, Input* vx_input, Input* vy_input, Input* vz_input);
		Penta*  GetUpperElement(void);
		Penta*  GetLowerElement(void);
		Penta*  GetBasalElement(void);
		void	  InputExtrude(int enum_type,int object_type);
		void    InputUpdateFromSolutionAdjointHoriz( double* solutiong);
		void    InputUpdateFromSolutionAdjointStokes( double* solutiong);
		void    InputUpdateFromSolutionDiagnosticHoriz( double* solutiong);
		void    InputUpdateFromSolutionDiagnosticMacAyeal( double* solutiong);
		void    InputUpdateFromSolutionDiagnosticMacAyealPattyn( double* solutiong);
		void    InputUpdateFromSolutionDiagnosticMacAyealStokes( double* solutiong);
		void    InputUpdateFromSolutionDiagnosticPattyn( double* solutiong);
		void    InputUpdateFromSolutionDiagnosticPattynStokes( double* solutiong);
		void    InputUpdateFromSolutionDiagnosticHutter( double* solutiong);
		void    InputUpdateFromSolutionDiagnosticVert( double* solutiong);
		void    InputUpdateFromSolutionDiagnosticStokes( double* solutiong);
		void    InputUpdateFromSolutionPrognostic(double* solutiong);
		void    InputUpdateFromSolutionThermal( double* solutiong);
		void    InputUpdateFromSolutionOneDof(double* solutiong,int enum_type);
		void    InputUpdateFromSolutionOneDofCollapsed(double* solutiong,int enum_type);
		bool	  IsInput(int name);
		bool	  IsOnSurface(void);
		bool	  IsOnBed(void);
		bool    IsOnShelf(void); 
		bool    IsNodeOnShelf(void); 
		bool    IsOnWater(void); 
		double  MinEdgeLength(double xyz_list[6][3]);
	   void	  ReduceMatrixStokes(double* Ke_reduced, double* Ke_temp);
		void	  ReduceVectorStokes(double* Pe_reduced, double* Ke_temp, double* Pe_temp);
		void	  SetClone(int* minranks);
		Tria*	  SpawnTria(int g0, int g1, int g2);
		void	  SurfaceNormal(double* surface_normal, double xyz_list[3][3]);
		/*}}}*/
};
#endif  /* _PENTA_H */
