/*!\file GroundingLineMigrationx
 * \brief: migration grounding line position.
 */

#include "./GroundingLineMigrationx.h"
#include "./GroundingLineMigrationxLocal.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void GroundingLineMigrationx(Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters){

	int i,j;
	Element* element=NULL;
	double*  element_touching_iceshelf=NULL;
	int      nflipped;

	_printf_(VerboseModule(),"   Migrating grounding line\n");

	/*Loop until no more nodes and elements  change from grounded to floating: */
	nflipped=1; //arbitrary, get things started

	while(nflipped){

		/*reset counter: */
		nflipped=0;

		/*Create  vector holding  all the elements that touch the ice shelf, by any node: */
		element_touching_iceshelf=CreateElementTouchingIceShelf(elements);

		/*Carry out grounding line migration for those elements: */
		for(i=0;i<elements->Size();i++){
			element=(Element*)elements->GetObjectByOffset(i);
			if(element_touching_iceshelf[element->Sid()]) element->MigrateGroundingLine();
		}

		/*Now, update shelf flags in nodes and elements: */
		nflipped=UpdateShelfStatus(elements,nodes,parameters,element_touching_iceshelf);
		_printf_(VerboseModule(),"      number of migrated nodes: %i\n",nflipped);

		/*avoid memory leaks: */
		xfree((void**)&element_touching_iceshelf);
	}
		
	
	/*free ressouces: */
	xfree((void**)&element_touching_iceshelf);
}
