function md=prognostic(md)
%THERMAL - prognostic solution sequence.
%
%   Usage:
%      md=prognostic(md)

	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	displaystring(md.debug,'%s',['reading prognostic model data']);
	md.analysis_type='prognostic'; m_p=CreateFemModel(md);

	% figure out number of dof: just for information purposes.
	md.dof=m_p.nodesets.fsize;

	%initialize inputs
	displaystring(md.debug,'\n%s',['setup inputs...']);
	inputs=inputlist;
	inputs=add(inputs,'velocity',m_p.parameters.u_g,'doublevec',3,m_p.parameters.numberofnodes);
	inputs=add(inputs,'thickness',m_p.parameters.h_g,'doublevec',1,m_p.parameters.numberofnodes);
	inputs=add(inputs,'melting',m_p.parameters.m_g,'doublevec',1,m_p.parameters.numberofnodes);
	inputs=add(inputs,'accumulation',m_p.parameters.a_g,'doublevec',1,m_p.parameters.numberofnodes);
	inputs=add(inputs,'dt',m_p.parameters.dt,'double');

	displaystring(md.debug,'\n%s',['call computational core:']);
	h_g=prognostic_core(m_p,inputs,'prognostic','');

	displaystring(md.debug,'\n%s',['load results...']);
	md.results.prognostic.step=1;
	md.results.prognostic.time=0;
	md.results.prognostic.thickness=h_g;

	%stop timing
	t2=clock;
	displaystring(md.debug,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);	
